/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.ssf.FastState;
import ec.tstoolkit.ssf.FilteredData;
import ec.tstoolkit.ssf.IFastFilteringResults;
import ec.tstoolkit.ssf.IFilteringResults;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.ResidualsCumulator;
import ec.tstoolkit.ssf.State;
import ec.tstoolkit.ssf.VarianceFilter;

public class FilteringResults
extends ResidualsCumulator
implements IFilteringResults,
IFastFilteringResults {
    private final VarianceFilter m_var;
    private final FilteredData m_fdata;

    public FilteringResults() {
        this.m_var = new VarianceFilter();
        this.m_fdata = new FilteredData();
    }

    public FilteringResults(boolean hasC) {
        this.m_var = new VarianceFilter(hasC);
        this.m_fdata = new FilteredData();
    }

    @Override
    public void clear() {
        super.clear();
        this.m_fdata.clear();
        this.m_var.clear();
    }

    @Override
    public void close() {
    }

    public FilteredData getFilteredData() {
        return this.m_fdata;
    }

    public VarianceFilter getVarianceFilter() {
        return this.m_var;
    }

    @Override
    public void prepare(ISsf ssf, ISsfData data) {
        if (this.m_var.isOpen()) {
            this.m_fdata.checkSize(data.getCount());
        } else {
            super.clear();
            this.m_fdata.init(ssf.getStateDim(), data.getCount());
        }
        this.m_var.prepare(ssf, data);
    }

    @Override
    public void save(int t, FastState state) {
        this.m_var.save(t, state);
        this.m_fdata.save(t, state);
        if (!state.isMissing()) {
            super.add(state.e, state.f);
        }
    }

    @Override
    public void save(int t, State state) {
        this.m_var.save(t, state);
        this.m_fdata.save(t, state);
        if (!state.isMissing()) {
            super.add(state.e, state.f);
        }
    }
}

