/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.special;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.satoolkit.ISaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.ssf.ExtendedSsfData;
import ec.tstoolkit.ssf.Smoother;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.structural.BasicStructuralModel;
import ec.tstoolkit.structural.BsmMonitor;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.ucarima.UcarimaModel;
import ec.tstoolkit.ucarima.WienerKolmogorovEstimators;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class StmResults
implements ISaResults {
    public static final String MODEL = "model";
    public static final String SERIES = "series";
    public static final String LEVEL = "level";
    public static final String CYCLE = "cycle";
    public static final String SLOPE = "slope";
    public static final String NOISE = "noise";
    public static final String SEASONAL = "seasonal";
    public static final String RESIDUALS = "residuals";
    private final BsmMonitor monitor_;
    private final SmoothingResults srslts_;
    private final InformationSet info_ = new InformationSet();
    private final TsData y_;
    private final TsData yf_;
    private final TsData t_;
    private final TsData sa_;
    private final TsData s_;
    private final TsData i_;
    private final TsData c_;
    private UcarimaModel reduced_;
    private double errFactor_;
    private WienerKolmogorovEstimators wk_;
    private final boolean mul_;
    private final TsVariableList x_;
    private static final InformationMapping<StmResults> MAPPING = new InformationMapping<StmResults>(StmResults.class);

    public StmResults(TsData y, TsVariableList x, BsmMonitor monitor, boolean mul) {
        this.monitor_ = monitor;
        this.y_ = y;
        this.x_ = x;
        this.mul_ = mul;
        BasicStructuralModel model = monitor.getResult();
        Smoother smoother = new Smoother();
        smoother.setSsf(model);
        ExtendedSsfData data = new ExtendedSsfData(new SsfData(y.internalStorage(), null));
        data.setForecastsCount(y.getFrequency().intValue());
        this.srslts_ = new SmoothingResults();
        smoother.process(data, this.srslts_);
        InformationSet minfo = this.info_.subSet(MODEL);
        int[] cmps = model.getCmpPositions();
        int cur = 0;
        TsData seasonal = null;
        TsData cycle = null;
        if (model.getSpecification().hasNoise()) {
            TsData noise = new TsData(y.getStart(), this.srslts_.component(cmps[cur++]), false);
            minfo.add(NOISE, noise);
            this.i_ = noise;
        } else {
            this.i_ = new TsData(y.getDomain(), 0.0);
        }
        if (model.getSpecification().hasCycle()) {
            cycle = new TsData(y.getStart(), this.srslts_.component(cmps[cur++]), false);
            minfo.add(CYCLE, cycle);
            this.c_ = cycle;
        } else {
            this.c_ = new TsData(y.getDomain(), 0.0);
        }
        if (model.getSpecification().hasLevel()) {
            TsData level = new TsData(y.getStart(), this.srslts_.component(cmps[cur++]), false);
            minfo.add(LEVEL, level);
            this.t_ = TsData.add(level, cycle);
            if (model.getSpecification().hasSlope()) {
                TsData slope = new TsData(y.getStart(), this.srslts_.component(cmps[cur++]), false);
                minfo.add(SLOPE, slope);
            }
        } else {
            this.t_ = this.c_;
        }
        if (model.getSpecification().hasSeasonal()) {
            seasonal = new TsData(y.getStart(), this.srslts_.component(cmps[cur++]), false);
            minfo.add(SEASONAL, seasonal);
            this.s_ = seasonal;
        } else {
            this.s_ = new TsData(y.getDomain(), 0.0);
        }
        minfo.add(SERIES, y);
        TsData all = TsData.add(this.t_, this.s_);
        all = TsData.add(all, this.i_);
        all = all.update(this.y_);
        this.sa_ = TsData.subtract(all, seasonal);
        this.yf_ = all.drop(this.y_.getLength(), 0);
    }

    public TsVariableList getX() {
        return this.x_;
    }

    public List<String> getTsDataDictionary() {
        return this.info_.getDictionary(TsData.class);
    }

    @Override
    public boolean contains(String id) {
        if (MAPPING.contains(id)) {
            return true;
        }
        if (this.info_ != null) {
            if (!id.contains(InformationSet.STRSEP)) {
                return this.info_.deepSearch(id, Object.class) != null;
            }
            return this.info_.search(id, Object.class) != null;
        }
        return false;
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.EMPTY_LIST;
    }

    public ISeriesDecomposition getComponents() {
        DefaultSeriesDecomposition decomposition = new DefaultSeriesDecomposition(DecompositionMode.Additive);
        TsDomain dom = this.y_.getDomain();
        TsDomain fdom = this.yf_.getDomain();
        decomposition.add(this.y_, ComponentType.Series);
        decomposition.add(this.sa_.fittoDomain(dom), ComponentType.SeasonallyAdjusted);
        decomposition.add(this.t_.fittoDomain(dom), ComponentType.Trend);
        decomposition.add(this.s_.fittoDomain(dom), ComponentType.Seasonal);
        decomposition.add(this.i_.fittoDomain(dom), ComponentType.Irregular);
        decomposition.add(this.yf_, ComponentType.Series, ComponentInformation.Forecast);
        decomposition.add(this.sa_.fittoDomain(fdom), ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
        decomposition.add(this.t_.fittoDomain(fdom), ComponentType.Trend, ComponentInformation.Forecast);
        decomposition.add(this.s_.fittoDomain(fdom), ComponentType.Seasonal, ComponentInformation.Forecast);
        decomposition.add(this.i_.fittoDomain(fdom), ComponentType.Irregular, ComponentInformation.Forecast);
        return decomposition;
    }

    @Override
    public ISeriesDecomposition getSeriesDecomposition() {
        if (!this.mul_) {
            return this.getComponents();
        }
        DefaultSeriesDecomposition decomposition = new DefaultSeriesDecomposition(DecompositionMode.Multiplicative);
        TsDomain dom = this.y_.getDomain();
        TsDomain fdom = this.yf_.getDomain();
        decomposition.add(this.y_.exp(), ComponentType.Series);
        decomposition.add(this.sa_.fittoDomain(dom).exp(), ComponentType.SeasonallyAdjusted);
        decomposition.add(this.t_.fittoDomain(dom).exp(), ComponentType.Trend);
        decomposition.add(this.s_.fittoDomain(dom).exp(), ComponentType.Seasonal);
        decomposition.add(this.i_.fittoDomain(dom).exp(), ComponentType.Irregular);
        decomposition.add(this.yf_.exp(), ComponentType.Series, ComponentInformation.Forecast);
        decomposition.add(this.sa_.fittoDomain(fdom).exp(), ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
        decomposition.add(this.t_.fittoDomain(fdom).exp(), ComponentType.Trend, ComponentInformation.Forecast);
        decomposition.add(this.s_.fittoDomain(fdom).exp(), ComponentType.Seasonal, ComponentInformation.Forecast);
        decomposition.add(this.i_.fittoDomain(fdom).exp(), ComponentType.Irregular, ComponentInformation.Forecast);
        return decomposition;
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        MAPPING.fillDictionary(null, map, false);
        return map;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        if (MAPPING.contains(id)) {
            return MAPPING.getData(this, id, tclass);
        }
        if (!id.contains(InformationSet.STRSEP)) {
            return this.info_.deepSearch(id, tclass);
        }
        return this.info_.search(id, tclass);
    }

    public UcarimaModel getUcarimaModel() {
        if (this.reduced_ == null) {
            this.reduced_ = this.monitor_.getResult().computeReducedModel(false);
            this.errFactor_ = this.reduced_.normalize();
        }
        return this.reduced_;
    }

    public double getResidualsScalingFactor() {
        if (this.reduced_ == null) {
            this.reduced_ = this.monitor_.getResult().computeReducedModel(false);
            this.errFactor_ = this.reduced_.normalize();
        }
        return Math.sqrt(this.errFactor_);
    }

    public BasicStructuralModel getModel() {
        return this.monitor_.getResult();
    }

    public WienerKolmogorovEstimators getWienerKolmogorovEstimators() {
        if (this.wk_ == null) {
            this.wk_ = new WienerKolmogorovEstimators(this.getUcarimaModel());
        }
        return this.wk_;
    }

    public TsData getResiduals() {
        TsDomain domain = this.y_.getDomain();
        double[] res = this.monitor_.getLikelihood().getResiduals();
        return new TsData(domain.getStart().plus(domain.getLength() - res.length), res, false);
    }

    public DiffuseConcentratedLikelihood getLikelihood() {
        return this.monitor_.getLikelihood();
    }

    public IFunction likelihoodFunction() {
        return this.monitor_.likelihoodFunction();
    }

    public IFunctionInstance maxLikelihoodFunction() {
        return this.monitor_.maxLikelihoodFunction();
    }

    @Override
    public InformationSet getInformation() {
        return this.info_;
    }

    public static InformationMapping<StmResults> getMapping() {
        return MAPPING;
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<StmResults, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static <T> void setTsData(String name, Function<StmResults, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    static {
        MAPPING.set("y_cmp", source -> source.mul_ ? source.y_.exp() : source.y_);
        MAPPING.set("y_cmp_f", source -> source.mul_ ? source.yf_.exp() : source.yf_);
        MAPPING.set("t_cmp", source -> {
            TsData x = source.t_.fittoDomain(source.y_.getDomain());
            return source.mul_ ? x.exp() : x;
        });
        MAPPING.set("t_cmp_f", source -> {
            TsData x = source.t_.fittoDomain(source.yf_.getDomain());
            return source.mul_ ? x.exp() : x;
        });
        MAPPING.set("t_cmp_f", source -> {
            TsData x = source.t_.fittoDomain(source.yf_.getDomain());
            return source.mul_ ? x.exp() : x;
        });
        MAPPING.set("sa_cmp", source -> {
            TsData x = source.sa_.fittoDomain(source.y_.getDomain());
            return source.mul_ ? x.exp() : x;
        });
        MAPPING.set("sa_cmp_f", source -> {
            TsData x = source.sa_.fittoDomain(source.yf_.getDomain());
            return source.mul_ ? x.exp() : x;
        });
        MAPPING.set("s_cmp", source -> {
            TsData x = source.s_.fittoDomain(source.y_.getDomain());
            return source.mul_ ? x.exp() : x;
        });
        MAPPING.set("s_cmp_f", source -> {
            TsData x = source.s_.fittoDomain(source.yf_.getDomain());
            return source.mul_ ? x.exp() : x;
        });
        MAPPING.set("i_cmp", source -> {
            TsData x = source.i_.fittoDomain(source.y_.getDomain());
            return source.mul_ ? x.exp() : x;
        });
        MAPPING.set("i_cmp_f", source -> {
            TsData x = source.i_.fittoDomain(source.yf_.getDomain());
            return source.mul_ ? x.exp() : x;
        });
        MAPPING.set("si_cmp", source -> {
            TsData si = TsData.add(source.s_, source.i_);
            return source.mul_ ? si.exp() : si;
        });
        MAPPING.set("y_lin", source -> source.y_);
        MAPPING.set("y_lin_f", source -> source.yf_);
        MAPPING.set("t_lin", source -> source.t_.fittoDomain(source.y_.getDomain()));
        MAPPING.set("t_lin_f", source -> source.t_.fittoDomain(source.yf_.getDomain()));
        MAPPING.set("sa_lin", source -> source.sa_.fittoDomain(source.y_.getDomain()));
        MAPPING.set("sa_lin_f", source -> source.sa_.fittoDomain(source.yf_.getDomain()));
        MAPPING.set("s_lin", source -> source.s_.fittoDomain(source.y_.getDomain()));
        MAPPING.set("s_lin_f", source -> source.s_.fittoDomain(source.yf_.getDomain()));
        MAPPING.set("i_lin", source -> source.i_.fittoDomain(source.y_.getDomain()));
        MAPPING.set("i_lin_f", source -> source.i_.fittoDomain(source.yf_.getDomain()));
        MAPPING.set(RESIDUALS, source -> source.getResiduals());
    }
}

