library(png)
path <- file.path(system.file(package = "RImageJROI"), "extdata", "ijroi")
im <- as.raster(readPNG(file.path(path, "imagej-logo.png")))
plot(NA, NA, xlim=c(0, ncol(im)), ylim=c(nrow(im), 0), asp=1) 
rasterImage(im, 0,  nrow(im), ncol(im), 0, interpolate=FALSE)
r <- read.ijroi(file.path(path, "rect.roi"))
plot(r, TRUE)
r <- read.ijroi(file.path(path, "polygon.roi"))
plot(r, TRUE)
r <- read.ijroi(file.path(path, "oval.roi"))
plot(r, TRUE)
