/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.gui.ColorChooser;
import ij.gui.Toolbar;
import ij.plugin.frame.ColorGenerator;
import ij.plugin.frame.Recorder;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

class ColorCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    int width;
    int height;
    Vector colors;
    boolean background;
    long mouseDownTime;
    ColorGenerator ip;
    Frame frame;

    public ColorCanvas(int n, int n2, Frame frame, ColorGenerator colorGenerator) {
        this.width = n;
        this.height = n2;
        this.frame = frame;
        this.ip = colorGenerator;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(IJ.getInstance());
        this.setSize(n, n2);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.ip.createImage(), 0, 0, null);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.ip.setLineWidth(1);
        if (Toolbar.getToolId() == 13) {
            IJ.setTool(0);
        }
        Rectangle rectangle = new Rectangle(86, 268, 18, 18);
        Rectangle rectangle2 = new Rectangle(86, 294, 18, 18);
        Rectangle rectangle3 = new Rectangle(9, 266, 45, 10);
        Rectangle rectangle4 = new Rectangle(9, 276, 23, 25);
        Rectangle rectangle5 = new Rectangle(33, 302, 45, 10);
        Rectangle rectangle6 = new Rectangle(56, 277, 23, 25);
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        long l = System.currentTimeMillis() - this.mouseDownTime;
        boolean bl = l <= 250L;
        this.mouseDownTime = System.currentTimeMillis();
        if (rectangle.contains(n, n2)) {
            Color color = Toolbar.getBackgroundColor();
            Toolbar.setBackgroundColor(Toolbar.getForegroundColor());
            Toolbar.setForegroundColor(color);
        } else if (rectangle2.contains(n, n2)) {
            Toolbar.setForegroundColor(new Color(0));
            Toolbar.setBackgroundColor(new Color(0xFFFFFF));
        } else if (rectangle5.contains(n, n2) || rectangle6.contains(n, n2)) {
            this.background = true;
            if (bl) {
                this.editColor();
            }
            this.ip.refreshForeground();
            this.ip.refreshBackground();
        } else if (rectangle3.contains(n, n2) || rectangle4.contains(n, n2)) {
            this.background = false;
            if (bl) {
                this.editColor();
            }
            this.ip.refreshBackground();
            this.ip.refreshForeground();
        } else if (bl) {
            this.editColor();
        } else {
            this.setDrawingColor(n, n2, this.background);
        }
        if (this.background) {
            this.ip.refreshForeground();
            this.ip.refreshBackground();
        } else {
            this.ip.refreshBackground();
            this.ip.refreshForeground();
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.ip.getPixel(n, n2);
        int n4 = (n3 & 0xFF0000) >> 16;
        int n5 = (n3 & 0xFF00) >> 8;
        int n6 = n3 & 0xFF;
        IJ.showStatus("red=" + this.pad(n4) + ", green=" + this.pad(n5) + ", blue=" + this.pad(n6));
    }

    String pad(int n) {
        String string = "" + n;
        while (string.length() < 3) {
            string = "0" + string;
        }
        return string;
    }

    void setDrawingColor(int n, int n2, boolean bl) {
        int n3 = this.ip.getPixel(n, n2);
        int n4 = (n3 & 0xFF0000) >> 16;
        int n5 = (n3 & 0xFF00) >> 8;
        int n6 = n3 & 0xFF;
        Color color = new Color(n4, n5, n6);
        if (bl) {
            Toolbar.setBackgroundColor(color);
            if (Recorder.record) {
                Recorder.record("setBackgroundColor", color.getRed(), color.getGreen(), color.getBlue());
            }
        } else {
            Toolbar.setForegroundColor(color);
            if (Recorder.record) {
                Recorder.record("setForegroundColor", color.getRed(), color.getGreen(), color.getBlue());
            }
        }
    }

    void editColor() {
        Color color = this.background ? Toolbar.getBackgroundColor() : Toolbar.getForegroundColor();
        ColorChooser colorChooser = new ColorChooser((this.background ? "Background" : "Foreground") + " Color", color, false, this.frame);
        color = colorChooser.getColor();
        if (this.background) {
            Toolbar.setBackgroundColor(color);
        } else {
            Toolbar.setForegroundColor(color);
        }
    }

    public void refreshColors() {
        this.ip.refreshBackground();
        this.ip.refreshForeground();
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

