/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.macro.Interpreter;
import ij.macro.Program;
import ij.macro.Tokenizer;

public class CurveFitter {
    public static final int STRAIGHT_LINE = 0;
    public static final int POLY2 = 1;
    public static final int POLY3 = 2;
    public static final int POLY4 = 3;
    public static final int EXPONENTIAL = 4;
    public static final int POWER = 5;
    public static final int LOG = 6;
    public static final int RODBARD = 7;
    public static final int GAMMA_VARIATE = 8;
    public static final int LOG2 = 9;
    public static final int RODBARD2 = 10;
    public static final int EXP_WITH_OFFSET = 11;
    public static final int GAUSSIAN = 12;
    public static final int EXP_RECOVERY = 13;
    private static final int CUSTOM = 20;
    public static final int IterFactor = 500;
    public static final String[] fitList = new String[]{"Straight Line", "2nd Degree Polynomial", "3rd Degree Polynomial", "4th Degree Polynomial", "Exponential", "Power", "Log", "Rodbard", "Gamma Variate", "y = a+b*ln(x-c)", "Rodbard (NIH Image)", "Exponential with Offset", "Gaussian", "Exponential Recovery"};
    public static final String[] fList = new String[]{"y = a+bx", "y = a+bx+cx^2", "y = a+bx+cx^2+dx^3", "y = a+bx+cx^2+dx^3+ex^4", "y = a*exp(bx)", "y = ax^b", "y = a*ln(bx)", "y = d+(a-d)/(1+(x/c)^b)", "y = a*(x-b)^c*exp(-(x-b)/d)", "y = a+b*ln(x-c)", "y = d+(a-d)/(1+(x/c)^b)", "y = a*exp(-bx) + c", "y = a + (b-a)*exp(-(x-c)*(x-c)/(2*d*d))", "y=a*(1-exp(-b*x)) + c"};
    private static final double alpha = -1.0;
    private static final double beta = 0.5;
    private static final double gamma = 2.0;
    private static final double root2 = 1.414214;
    private int fit;
    private double[] xData;
    private double[] yData;
    private int numPoints;
    private int numParams;
    private int numVertices;
    private int worst;
    private int nextWorst;
    private int best;
    private double[][] simp;
    private double[] next;
    private int numIter;
    private int maxIter;
    private int restarts;
    private static int defaultRestarts = 2;
    private int nRestarts;
    private static double maxError = 1.0E-10;
    private double[] initialParams;
    private long time;
    private String customFormula;
    private int customParamCount;
    private Interpreter macro;
    private double[] initialValues;

    public CurveFitter(double[] dArray, double[] dArray2) {
        this.xData = dArray;
        this.yData = dArray2;
        this.numPoints = dArray.length;
    }

    public void doFit(int n) {
        this.doFit(n, false);
    }

    public void doFit(int n, boolean bl) {
        if (n < 0 || n > 13 && n != 20) {
            throw new IllegalArgumentException("Invalid fit type");
        }
        int n2 = n;
        if (n == 10) {
            double[] dArray = this.xData;
            this.xData = this.yData;
            this.yData = dArray;
            n = 7;
        }
        this.fit = n;
        this.initialize();
        if (this.initialParams != null) {
            for (int i = 0; i < this.numParams; ++i) {
                this.simp[0][i] = this.initialParams[i];
            }
            this.initialParams = null;
        }
        if (bl) {
            this.settingsDialog();
        }
        long l = System.currentTimeMillis();
        this.restart(0);
        this.numIter = 0;
        boolean bl2 = false;
        double[] dArray = new double[this.numParams];
        while (!bl2) {
            int n3;
            int n4;
            ++this.numIter;
            for (n4 = 0; n4 < this.numParams; ++n4) {
                dArray[n4] = 0.0;
            }
            for (n4 = 0; n4 < this.numVertices; ++n4) {
                if (n4 == this.worst) continue;
                for (n3 = 0; n3 < this.numParams; ++n3) {
                    int n5 = n3;
                    dArray[n5] = dArray[n5] + this.simp[n4][n3];
                }
            }
            for (n4 = 0; n4 < this.numParams; ++n4) {
                int n6 = n4;
                dArray[n6] = dArray[n6] / (double)this.numParams;
                this.next[n4] = dArray[n4] + -1.0 * (this.simp[this.worst][n4] - dArray[n4]);
            }
            this.sumResiduals(this.next);
            if (this.next[this.numParams] <= this.simp[this.best][this.numParams]) {
                this.newVertex();
                for (n4 = 0; n4 < this.numParams; ++n4) {
                    this.next[n4] = dArray[n4] + 2.0 * (this.simp[this.worst][n4] - dArray[n4]);
                }
                this.sumResiduals(this.next);
                if (this.next[this.numParams] <= this.simp[this.worst][this.numParams]) {
                    this.newVertex();
                }
            } else if (this.next[this.numParams] <= this.simp[this.nextWorst][this.numParams]) {
                this.newVertex();
            } else {
                for (n4 = 0; n4 < this.numParams; ++n4) {
                    this.next[n4] = dArray[n4] + 0.5 * (this.simp[this.worst][n4] - dArray[n4]);
                }
                this.sumResiduals(this.next);
                if (this.next[this.numParams] <= this.simp[this.nextWorst][this.numParams]) {
                    this.newVertex();
                } else {
                    for (n4 = 0; n4 < this.numVertices; ++n4) {
                        if (n4 == this.best) continue;
                        for (n3 = 0; n3 < this.numVertices; ++n3) {
                            this.simp[n4][n3] = 0.5 * (this.simp[n4][n3] + this.simp[this.best][n3]);
                        }
                        this.sumResiduals(this.simp[n4]);
                    }
                }
            }
            this.order();
            double d = 2.0 * Math.abs(this.simp[this.best][this.numParams] - this.simp[this.worst][this.numParams]) / (Math.abs(this.simp[this.best][this.numParams]) + Math.abs(this.simp[this.worst][this.numParams]) + 1.0E-10);
            if (this.numIter >= this.maxIter) {
                bl2 = true;
                continue;
            }
            if (!(d < maxError)) continue;
            --this.restarts;
            if (this.restarts < 0) {
                bl2 = true;
                continue;
            }
            this.restart(this.best);
        }
        this.fit = n2;
        this.time = System.currentTimeMillis() - l;
    }

    public int doCustomFit(String string, double[] dArray, boolean bl) {
        this.customFormula = null;
        this.customParamCount = 0;
        Program program = new Tokenizer().tokenize(string);
        if (!program.hasWord("y")) {
            return 0;
        }
        if (!program.hasWord("x")) {
            return 0;
        }
        String[] stringArray = new String[]{"a", "b", "c", "d", "e", "f"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!program.hasWord(stringArray[i])) continue;
            ++this.customParamCount;
        }
        if (this.customParamCount == 0) {
            return 0;
        }
        this.customFormula = string;
        String string2 = "var x, a, b, c, d, e, f;\nfunction dummy() {}\n" + string + ";\n";
        this.macro = new Interpreter();
        this.macro.run(string2, null);
        if (this.macro.wasError()) {
            return 0;
        }
        this.initialValues = dArray;
        this.doFit(20, bl);
        return this.customParamCount;
    }

    private void settingsDialog() {
        int n;
        GenericDialog genericDialog = new GenericDialog("Simplex Fitting Options");
        genericDialog.addMessage("Function name: " + this.getName() + "\n" + "Formula: " + this.getFormula());
        char c = 'a';
        for (n = 0; n < this.numParams; ++n) {
            genericDialog.addNumericField("Initial " + new Character(c).toString() + ":", this.simp[0][n], 2);
            c = (char)(c + '\u0001');
        }
        genericDialog.addNumericField("Maximum iterations:", this.maxIter, 0);
        genericDialog.addNumericField("Number of restarts:", defaultRestarts, 0);
        genericDialog.addNumericField("Error tolerance [1*10^(-x)]:", -(Math.log(maxError) / Math.log(10.0)), 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled() || genericDialog.invalidNumber()) {
            IJ.error("Parameter setting canceled.\nUsing default parameters.");
        }
        for (n = 0; n < this.numParams; ++n) {
            this.simp[0][n] = genericDialog.getNextNumber();
        }
        this.maxIter = (int)genericDialog.getNextNumber();
        defaultRestarts = this.restarts = (int)genericDialog.getNextNumber();
        maxError = Math.pow(10.0, -genericDialog.getNextNumber());
    }

    void initialize() {
        this.numParams = this.getNumParams();
        this.numVertices = this.numParams + 1;
        this.simp = new double[this.numVertices][this.numVertices];
        this.next = new double[this.numVertices];
        double d = this.xData[0];
        double d2 = this.yData[0];
        double d3 = this.xData[this.numPoints - 1];
        double d4 = this.yData[this.numPoints - 1];
        double d5 = (d + d3) / 2.0;
        double d6 = (d2 + d4) / 2.0;
        double d7 = d2;
        double d8 = d2;
        if (this.fit == 12) {
            for (int i = 1; i < this.numPoints; ++i) {
                if (this.yData[i] > d8) {
                    d8 = this.yData[i];
                }
                if (!(this.yData[i] < d7)) continue;
                d7 = this.yData[i];
            }
        }
        double d9 = d3 - d != 0.0 ? (d4 - d2) / (d3 - d) : 1.0;
        double d10 = d2 - d9 * d;
        this.maxIter = 500 * this.numParams * this.numParams;
        this.restarts = defaultRestarts;
        this.nRestarts = 0;
        switch (this.fit) {
            case 0: {
                this.simp[0][0] = d10;
                this.simp[0][1] = d9;
                break;
            }
            case 1: {
                this.simp[0][0] = d10;
                this.simp[0][1] = d9;
                this.simp[0][2] = 0.0;
                break;
            }
            case 2: {
                this.simp[0][0] = d10;
                this.simp[0][1] = d9;
                this.simp[0][2] = 0.0;
                this.simp[0][3] = 0.0;
                break;
            }
            case 3: {
                this.simp[0][0] = d10;
                this.simp[0][1] = d9;
                this.simp[0][2] = 0.0;
                this.simp[0][3] = 0.0;
                this.simp[0][4] = 0.0;
                break;
            }
            case 4: {
                this.simp[0][0] = 0.1;
                this.simp[0][1] = 0.01;
                break;
            }
            case 11: {
                this.simp[0][0] = 0.1;
                this.simp[0][1] = 0.01;
                this.simp[0][2] = 0.1;
                break;
            }
            case 13: {
                this.simp[0][0] = 0.1;
                this.simp[0][1] = 0.01;
                this.simp[0][2] = 0.1;
                break;
            }
            case 12: {
                this.simp[0][0] = d7;
                this.simp[0][1] = d8;
                this.simp[0][2] = d5;
                this.simp[0][3] = 3.0;
                break;
            }
            case 5: {
                this.simp[0][0] = 0.0;
                this.simp[0][1] = 1.0;
                break;
            }
            case 6: {
                this.simp[0][0] = 1.0;
                this.simp[0][1] = 1.0;
                break;
            }
            case 7: 
            case 10: {
                this.simp[0][0] = d2;
                this.simp[0][1] = 1.0;
                this.simp[0][2] = d5;
                this.simp[0][3] = d4;
                break;
            }
            case 8: {
                this.simp[0][0] = d;
                double d11 = this.xData[CurveFitter.getMax(this.yData)] - d;
                this.simp[0][2] = Math.sqrt(d11);
                this.simp[0][3] = Math.sqrt(d11);
                this.simp[0][1] = this.yData[CurveFitter.getMax(this.yData)] / (Math.pow(d11, this.simp[0][2]) * Math.exp(-d11 / this.simp[0][3]));
                break;
            }
            case 9: {
                this.simp[0][0] = 0.5;
                this.simp[0][1] = 0.05;
                this.simp[0][2] = 0.0;
                break;
            }
            case 20: {
                if (this.macro == null) {
                    throw new IllegalArgumentException("No custom formula!");
                }
                if (this.initialValues != null && this.initialValues.length >= this.numParams) {
                    for (int i = 0; i < this.numParams; ++i) {
                        this.simp[0][i] = this.initialValues[i];
                    }
                } else {
                    for (int i = 0; i < this.numParams; ++i) {
                        this.simp[0][i] = 1.0;
                    }
                }
                break;
            }
        }
    }

    void restart(int n) {
        int n2;
        for (int i = 0; i < this.numParams; ++i) {
            this.simp[0][i] = this.simp[n][i];
        }
        this.sumResiduals(this.simp[0]);
        double[] dArray = new double[this.numParams];
        for (int i = 0; i < this.numParams; ++i) {
            dArray[i] = this.simp[0][i] / 2.0;
            if (dArray[i] != 0.0) continue;
            dArray[i] = 0.01;
        }
        double[] dArray2 = new double[this.numParams];
        double[] dArray3 = new double[this.numParams];
        for (n2 = 0; n2 < this.numParams; ++n2) {
            dArray2[n2] = dArray[n2] * (Math.sqrt(this.numVertices) + (double)this.numParams - 1.0) / ((double)this.numParams * 1.414214);
            dArray3[n2] = dArray[n2] * (Math.sqrt(this.numVertices) - 1.0) / ((double)this.numParams * 1.414214);
        }
        for (n2 = 1; n2 < this.numVertices; ++n2) {
            for (int i = 0; i < this.numParams; ++i) {
                this.simp[n2][i] = this.simp[n2 - 1][i] + dArray3[i];
            }
            this.simp[n2][n2 - 1] = this.simp[n2][n2 - 1] + dArray2[n2 - 1];
            this.sumResiduals(this.simp[n2]);
        }
        this.best = 0;
        this.worst = 0;
        this.nextWorst = 0;
        this.order();
        ++this.nRestarts;
    }

    void showSimplex(int n) {
        IJ.log("" + n);
        for (int i = 0; i < this.numVertices; ++i) {
            String string = "";
            for (int j = 0; j < this.numVertices; ++j) {
                string = string + "  " + IJ.d2s(this.simp[i][j], 6);
            }
            IJ.log(string);
        }
    }

    public int getNumParams() {
        switch (this.fit) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 2;
            }
            case 7: 
            case 10: {
                return 4;
            }
            case 8: {
                return 4;
            }
            case 9: {
                return 3;
            }
            case 11: {
                return 3;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 3;
            }
            case 20: {
                return this.customParamCount;
            }
        }
        return 0;
    }

    public double f(double[] dArray, double d) {
        if (this.fit == 20) {
            this.macro.setVariable("x", d);
            this.macro.setVariable("a", dArray[0]);
            if (this.customParamCount > 1) {
                this.macro.setVariable("b", dArray[1]);
            }
            if (this.customParamCount > 2) {
                this.macro.setVariable("c", dArray[2]);
            }
            if (this.customParamCount > 3) {
                this.macro.setVariable("d", dArray[3]);
            }
            if (this.customParamCount > 4) {
                this.macro.setVariable("e", dArray[4]);
            }
            if (this.customParamCount > 5) {
                this.macro.setVariable("f", dArray[5]);
            }
            this.macro.run(21);
            return this.macro.getVariable("y");
        }
        return CurveFitter.f(this.fit, dArray, d);
    }

    public static double f(int n, double[] dArray, double d) {
        switch (n) {
            case 0: {
                return dArray[0] + dArray[1] * d;
            }
            case 1: {
                return dArray[0] + dArray[1] * d + dArray[2] * d * d;
            }
            case 2: {
                return dArray[0] + dArray[1] * d + dArray[2] * d * d + dArray[3] * d * d * d;
            }
            case 3: {
                return dArray[0] + dArray[1] * d + dArray[2] * d * d + dArray[3] * d * d * d + dArray[4] * d * d * d * d;
            }
            case 4: {
                return dArray[0] * Math.exp(dArray[1] * d);
            }
            case 11: {
                return dArray[0] * Math.exp(dArray[1] * d * -1.0) + dArray[2];
            }
            case 13: {
                return dArray[0] * (1.0 - Math.exp(-dArray[1] * d)) + dArray[2];
            }
            case 12: {
                return dArray[0] + (dArray[1] - dArray[0]) * Math.exp(-(d - dArray[2]) * (d - dArray[2]) / (2.0 * dArray[3] * dArray[3]));
            }
            case 5: {
                if (d == 0.0) {
                    return 0.0;
                }
                return dArray[0] * Math.exp(dArray[1] * Math.log(d));
            }
            case 6: {
                if (d == 0.0) {
                    d = 0.5;
                }
                return dArray[0] * Math.log(dArray[1] * d);
            }
            case 7: {
                double d2 = d == 0.0 ? 0.0 : Math.exp(Math.log(d / dArray[2]) * dArray[1]);
                double d3 = dArray[0] - dArray[3];
                return (d3 /= 1.0 + d2) + dArray[3];
            }
            case 8: {
                if (dArray[0] >= d) {
                    return 0.0;
                }
                if (dArray[1] <= 0.0) {
                    return -100000.0;
                }
                if (dArray[2] <= 0.0) {
                    return -100000.0;
                }
                if (dArray[3] <= 0.0) {
                    return -100000.0;
                }
                double d4 = Math.pow(d - dArray[0], dArray[2]);
                double d5 = Math.exp(-(d - dArray[0]) / dArray[3]);
                return dArray[1] * d4 * d5;
            }
            case 9: {
                double d6 = d - dArray[2];
                if (d6 < 0.001) {
                    d6 = 0.001;
                }
                return dArray[0] + dArray[1] * Math.log(d6);
            }
            case 10: {
                double d7;
                if (d <= dArray[0]) {
                    d7 = 0.0;
                } else {
                    d7 = (dArray[0] - d) / (d - dArray[3]);
                    d7 = Math.exp(Math.log(d7) * (1.0 / dArray[1]));
                    d7 *= dArray[2];
                }
                return d7;
            }
        }
        return 0.0;
    }

    public double[] getParams() {
        this.order();
        return this.simp[this.best];
    }

    public double[] getResiduals() {
        int n = this.fit;
        if (this.fit == 10) {
            this.fit = 7;
        }
        double[] dArray = this.getParams();
        double[] dArray2 = new double[this.numPoints];
        if (this.fit == 20) {
            for (int i = 0; i < this.numPoints; ++i) {
                dArray2[i] = this.yData[i] - this.f(dArray, this.xData[i]);
            }
        } else {
            for (int i = 0; i < this.numPoints; ++i) {
                dArray2[i] = this.yData[i] - CurveFitter.f(this.fit, dArray, this.xData[i]);
            }
        }
        this.fit = n;
        return dArray2;
    }

    public double getSumResidualsSqr() {
        double d = this.getParams()[this.getNumParams()];
        return d;
    }

    public double getSD() {
        double[] dArray = this.getResiduals();
        int n = dArray.length;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
            d2 += dArray[i] * dArray[i];
        }
        double d3 = ((double)n * d2 - d * d) / (double)n;
        return Math.sqrt(d3 / ((double)n - 1.0));
    }

    public double getRSquared() {
        double d = 0.0;
        for (int i = 0; i < this.numPoints; ++i) {
            d += this.yData[i];
        }
        double d2 = d / (double)this.numPoints;
        double d3 = 0.0;
        for (int i = 0; i < this.numPoints; ++i) {
            d3 += this.sqr(this.yData[i] - d2);
        }
        double d4 = 0.0;
        if (d3 > 0.0) {
            d4 = 1.0 - this.getSumResidualsSqr() / d3;
        }
        return d4;
    }

    public double getFitGoodness() {
        double d = 0.0;
        for (int i = 0; i < this.numPoints; ++i) {
            d += this.yData[i];
        }
        double d2 = d / (double)this.numPoints;
        double d3 = 0.0;
        int n = this.numPoints - this.getNumParams();
        double d4 = 0.0;
        for (int i = 0; i < this.numPoints; ++i) {
            d3 += this.sqr(this.yData[i] - d2);
        }
        if (d3 > 0.0 && n != 0) {
            d4 = 1.0 - this.getSumResidualsSqr() / (double)n * ((double)this.numPoints / d3);
        }
        return d4;
    }

    public String getResultString() {
        String string = "\nFormula: " + this.getFormula() + "\nTime: " + this.time + "ms" + "\nNumber of iterations: " + this.getIterations() + " (" + this.getMaxIterations() + ")" + "\nNumber of restarts: " + (this.nRestarts - 1) + " (" + defaultRestarts + ")" + "\nSum of residuals squared: " + IJ.d2s(this.getSumResidualsSqr(), 4) + "\nStandard deviation: " + IJ.d2s(this.getSD(), 4) + "\nR^2: " + IJ.d2s(this.getRSquared(), 4) + "\nParameters:";
        char c = 'a';
        double[] dArray = this.getParams();
        for (int i = 0; i < this.numParams; ++i) {
            string = string + "\n  " + c + " = " + IJ.d2s(dArray[i], 4);
            c = (char)(c + '\u0001');
        }
        return string;
    }

    double sqr(double d) {
        return d * d;
    }

    void sumResiduals(double[] dArray) {
        dArray[this.numParams] = 0.0;
        if (this.fit == 20) {
            for (int i = 0; i < this.numPoints; ++i) {
                dArray[this.numParams] = dArray[this.numParams] + this.sqr(this.f(dArray, this.xData[i]) - this.yData[i]);
            }
        } else {
            for (int i = 0; i < this.numPoints; ++i) {
                dArray[this.numParams] = dArray[this.numParams] + this.sqr(CurveFitter.f(this.fit, dArray, this.xData[i]) - this.yData[i]);
            }
        }
    }

    void newVertex() {
        for (int i = 0; i < this.numVertices; ++i) {
            this.simp[this.worst][i] = this.next[i];
        }
    }

    void order() {
        int n;
        for (n = 0; n < this.numVertices; ++n) {
            if (this.simp[n][this.numParams] < this.simp[this.best][this.numParams]) {
                this.best = n;
            }
            if (!(this.simp[n][this.numParams] > this.simp[this.worst][this.numParams])) continue;
            this.worst = n;
        }
        this.nextWorst = this.best;
        for (n = 0; n < this.numVertices; ++n) {
            if (n == this.worst || !(this.simp[n][this.numParams] > this.simp[this.nextWorst][this.numParams])) continue;
            this.nextWorst = n;
        }
    }

    public int getIterations() {
        return this.numIter;
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setMaxIterations(int n) {
        this.maxIter = n;
    }

    public int getRestarts() {
        return defaultRestarts;
    }

    public void setRestarts(int n) {
        defaultRestarts = n;
    }

    public void setInitialParameters(double[] dArray) {
        this.initialParams = dArray;
    }

    public static int getMax(double[] dArray) {
        double d = dArray[0];
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(d < dArray[i])) continue;
            d = dArray[i];
            n = i;
        }
        return n;
    }

    public double[] getXPoints() {
        return this.xData;
    }

    public double[] getYPoints() {
        return this.yData;
    }

    public int getFit() {
        return this.fit;
    }

    public String getName() {
        if (this.fit == 20) {
            return "User-defined";
        }
        return fitList[this.fit];
    }

    public String getFormula() {
        if (this.fit == 20) {
            return this.customFormula;
        }
        return fList[this.fit];
    }
}

