/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.ImagePlus;
import ij.measure.CurveFitter;
import ij.plugin.filter.Analyzer;

public class Calibration
implements Cloneable {
    public static final int STRAIGHT_LINE = 0;
    public static final int POLY2 = 1;
    public static final int POLY3 = 2;
    public static final int POLY4 = 3;
    public static final int EXPONENTIAL = 4;
    public static final int POWER = 5;
    public static final int LOG = 6;
    public static final int RODBARD = 7;
    public static final int GAMMA_VARIATE = 8;
    public static final int LOG2 = 9;
    public static final int RODBARD2 = 10;
    public static final int NONE = 20;
    public static final int UNCALIBRATED_OD = 21;
    public static final int CUSTOM = 22;
    public static final String DEFAULT_VALUE_UNIT = "Gray Value";
    public double pixelWidth = 1.0;
    public double pixelHeight = 1.0;
    public double pixelDepth = 1.0;
    public double frameInterval;
    public double fps;
    public boolean loop;
    public double xOrigin;
    public double yOrigin;
    public double zOrigin;
    public String info;
    private double[] coefficients;
    private String unit = "pixel";
    private String yunit;
    private String zunit;
    private String units;
    private String valueUnit = "Gray Value";
    private String timeUnit = "sec";
    private int function = 20;
    private float[] cTable;
    private boolean invertedLut;
    private int bitDepth = 8;
    private boolean zeroClip;
    private boolean invertY;

    public Calibration(ImagePlus imagePlus) {
        if (imagePlus != null) {
            this.bitDepth = imagePlus.getBitDepth();
            this.invertedLut = imagePlus.isInvertedLut();
        }
    }

    public Calibration() {
    }

    public boolean scaled() {
        return this.pixelWidth != 1.0 || this.pixelHeight != 1.0 || this.pixelDepth != 1.0 || !this.unit.equals("pixel");
    }

    public void setUnit(String string) {
        if (string == null || string.equals("")) {
            this.unit = "pixel";
        } else {
            if (string.equals("um")) {
                string = "\u00b5m";
            }
            this.unit = string;
        }
        this.units = null;
    }

    public void setXUnit(String string) {
        this.setUnit(string);
    }

    public void setYUnit(String string) {
        this.yunit = string;
    }

    public void setZUnit(String string) {
        this.zunit = string;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getXUnit() {
        return this.unit;
    }

    public String getYUnit() {
        return this.yunit != null ? this.yunit : this.unit;
    }

    public String getZUnit() {
        return this.zunit != null ? this.zunit : this.unit;
    }

    public String getUnits() {
        if (this.units == null) {
            this.units = this.unit.equals("pixel") ? "pixels" : (this.unit.equals("micron") ? "microns" : (this.unit.equals("inch") ? "inches" : this.unit));
        }
        return this.units;
    }

    public void setTimeUnit(String string) {
        this.timeUnit = string == null || string.equals("") ? "sec" : string;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public double getX(double d) {
        return (d - this.xOrigin) * this.pixelWidth;
    }

    public double getY(double d) {
        return (d - this.yOrigin) * this.pixelHeight;
    }

    public double getY(double d, int n) {
        if (this.invertY || (Analyzer.getMeasurements() & 0x1000) != 0) {
            if (this.yOrigin != 0.0) {
                return (this.yOrigin - d) * this.pixelHeight;
            }
            return ((double)n - d - 1.0) * this.pixelHeight;
        }
        return (d - this.yOrigin) * this.pixelHeight;
    }

    public double getZ(double d) {
        return (d - this.zOrigin) * this.pixelDepth;
    }

    public void setFunction(int n, double[] dArray, String string) {
        this.setFunction(n, dArray, string, false);
    }

    public void setFunction(int n, double[] dArray, String string, boolean bl) {
        if (n == 20) {
            this.disableDensityCalibration();
            return;
        }
        if (dArray == null && n >= 0 && n <= 10) {
            return;
        }
        this.function = n;
        this.coefficients = dArray;
        this.zeroClip = bl;
        if (string != null) {
            this.valueUnit = string;
        }
        this.cTable = null;
    }

    public void setImage(ImagePlus imagePlus) {
        if (imagePlus == null) {
            return;
        }
        int n = imagePlus.getType();
        int n2 = imagePlus.getBitDepth();
        if (n2 == 16 && imagePlus.getLocalCalibration().isSigned16Bit()) {
            double[] dArray = new double[]{-32768.0, 1.0};
            this.setFunction(0, dArray, DEFAULT_VALUE_UNIT);
        } else if (n2 != this.bitDepth || n == 2 || n == 4) {
            String string = this.valueUnit;
            this.disableDensityCalibration();
            if (n == 2) {
                this.valueUnit = string;
            }
        }
        this.bitDepth = n2;
    }

    public void disableDensityCalibration() {
        this.function = 20;
        this.coefficients = null;
        this.cTable = null;
        this.valueUnit = DEFAULT_VALUE_UNIT;
    }

    public String getValueUnit() {
        return this.valueUnit;
    }

    public void setValueUnit(String string) {
        if (string != null) {
            this.valueUnit = string;
        }
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    public boolean calibrated() {
        return this.function != 20;
    }

    public int getFunction() {
        return this.function;
    }

    public float[] getCTable() {
        if (this.cTable == null) {
            this.makeCTable();
        }
        return this.cTable;
    }

    public void setCTable(float[] fArray, String string) {
        if (fArray == null) {
            this.disableDensityCalibration();
            return;
        }
        if (this.bitDepth == 16 && fArray.length != 65536) {
            throw new IllegalArgumentException("Table.length!=65536");
        }
        this.cTable = fArray;
        this.function = 22;
        this.coefficients = null;
        this.zeroClip = false;
        if (string != null) {
            this.valueUnit = string;
        }
    }

    void makeCTable() {
        if (this.bitDepth == 16) {
            this.make16BitCTable();
            return;
        }
        if (this.bitDepth != 8) {
            return;
        }
        if (this.function == 21) {
            this.cTable = new float[256];
            for (int i = 0; i < 256; ++i) {
                this.cTable[i] = (float)this.od(i);
            }
        } else if (this.function >= 0 && this.function <= 10 && this.coefficients != null) {
            this.cTable = new float[256];
            for (int i = 0; i < 256; ++i) {
                double d = CurveFitter.f(this.function, this.coefficients, i);
                this.cTable[i] = this.zeroClip && d < 0.0 ? 0.0f : (float)d;
            }
        } else {
            this.cTable = null;
        }
    }

    void make16BitCTable() {
        if (this.function >= 0 && this.function <= 10 && this.coefficients != null) {
            this.cTable = new float[65536];
            for (int i = 0; i < 65536; ++i) {
                this.cTable[i] = (float)CurveFitter.f(this.function, this.coefficients, i);
            }
        } else {
            this.cTable = null;
        }
    }

    double od(double d) {
        if (this.invertedLut) {
            if (d == 255.0) {
                d = 254.5;
            }
            return 0.434294481 * Math.log(255.0 / (255.0 - d));
        }
        if (d == 0.0) {
            d = 0.5;
        }
        return 0.434294481 * Math.log(255.0 / d);
    }

    public double getCValue(int n) {
        if (this.function == 20) {
            return n;
        }
        if (this.function >= 0 && this.function <= 10 && this.coefficients != null) {
            double d = CurveFitter.f(this.function, this.coefficients, n);
            if (this.zeroClip && d < 0.0) {
                return 0.0;
            }
            return d;
        }
        if (this.cTable == null) {
            this.makeCTable();
        }
        if (this.cTable != null && n >= 0 && n < this.cTable.length) {
            return this.cTable[n];
        }
        return n;
    }

    public double getCValue(double d) {
        if (this.function == 20) {
            return d;
        }
        if (this.function >= 0 && this.function <= 10 && this.coefficients != null) {
            double d2 = CurveFitter.f(this.function, this.coefficients, d);
            if (this.zeroClip && d2 < 0.0) {
                return 0.0;
            }
            return d2;
        }
        return this.getCValue((int)d);
    }

    public double getRawValue(double d) {
        if (this.function == 20) {
            return d;
        }
        if (this.function == 0 && this.coefficients != null && this.coefficients.length == 2 && this.coefficients[1] != 0.0) {
            return (d - this.coefficients[0]) / this.coefficients[1];
        }
        if (this.cTable == null) {
            this.makeCTable();
        }
        float f = (float)d;
        float f2 = Float.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < this.cTable.length; ++i) {
            float f3 = f - this.cTable[i];
            if (f3 < 0.0f) {
                f3 = -f3;
            }
            if (!(f3 < f2)) continue;
            f2 = f3;
            n = i;
        }
        return n;
    }

    public Calibration copy() {
        return (Calibration)this.clone();
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Calibration calibration) {
        if (calibration == null) {
            return false;
        }
        boolean bl = true;
        if (calibration.pixelWidth != this.pixelWidth || calibration.pixelHeight != this.pixelHeight || calibration.pixelDepth != this.pixelDepth) {
            bl = false;
        }
        if (!calibration.unit.equals(this.unit)) {
            bl = false;
        }
        if (!calibration.valueUnit.equals(this.valueUnit) || calibration.function != this.function) {
            bl = false;
        }
        return bl;
    }

    public boolean isSigned16Bit() {
        return this.bitDepth == 16 && this.function >= 0 && this.function <= 10 && this.coefficients != null && this.coefficients[0] == -32768.0 && this.coefficients[1] == 1.0;
    }

    public void setSigned16BitCalibration() {
        double[] dArray = new double[]{-32768.0, 1.0};
        this.setFunction(0, dArray, DEFAULT_VALUE_UNIT);
    }

    public boolean zeroClip() {
        return this.zeroClip;
    }

    public void setInvertY(boolean bl) {
        this.invertY = bl;
    }

    public String toString() {
        return "w=" + this.pixelWidth + ", h=" + this.pixelHeight + ", d=" + this.pixelDepth + ", unit=" + this.unit + ", f=" + this.function + ", nc=" + (this.coefficients != null ? "" + this.coefficients.length : "null") + ", table=" + (this.cTable != null ? "" + this.cTable.length : "null") + ", vunit=" + this.valueUnit;
    }
}

