/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;

public class LookUpTable {
    private int width;
    private int height;
    private byte[] pixels;
    private int mapSize = 0;
    private ColorModel cm;
    private byte[] rLUT;
    private byte[] gLUT;
    private byte[] bLUT;

    public LookUpTable(Image image) {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
            this.cm = pixelGrabber.getColorModel();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getColors(this.cm);
    }

    public LookUpTable(ColorModel colorModel) {
        this.cm = colorModel;
        this.getColors(colorModel);
    }

    void getColors(ColorModel colorModel) {
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            this.mapSize = indexColorModel.getMapSize();
            this.rLUT = new byte[this.mapSize];
            this.gLUT = new byte[this.mapSize];
            this.bLUT = new byte[this.mapSize];
            indexColorModel.getReds(this.rLUT);
            indexColorModel.getGreens(this.gLUT);
            indexColorModel.getBlues(this.bLUT);
        }
    }

    public int getMapSize() {
        return this.mapSize;
    }

    public byte[] getReds() {
        return this.rLUT;
    }

    public byte[] getGreens() {
        return this.gLUT;
    }

    public byte[] getBlues() {
        return this.bLUT;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public boolean isGrayscale() {
        boolean bl = true;
        if (this.mapSize < 256) {
            return false;
        }
        for (int i = 0; i < this.mapSize; ++i) {
            if (this.rLUT[i] == this.gLUT[i] && this.gLUT[i] == this.bLUT[i]) continue;
            bl = false;
        }
        return bl;
    }

    public void drawColorBar(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.mapSize == 0) {
            return;
        }
        ColorProcessor colorProcessor = new ColorProcessor(n3, n4);
        double d = 256.0 / (double)this.mapSize;
        for (int i = 0; i < 256; ++i) {
            int n5 = (int)((double)i / d);
            colorProcessor.setColor(new Color(this.rLUT[n5] & 0xFF, this.gLUT[n5] & 0xFF, this.bLUT[n5] & 0xFF));
            colorProcessor.moveTo(i, 0);
            colorProcessor.lineTo(i, n4);
        }
        graphics.drawImage(colorProcessor.createImage(), n, n2, null);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3, n4);
    }

    public void drawUnscaledColorBar(ImageProcessor imageProcessor, int n, int n2, int n3, int n4) {
        ImageProcessor imageProcessor2 = null;
        imageProcessor2 = imageProcessor instanceof ColorProcessor ? new ColorProcessor(n3, n4) : new ByteProcessor(n3, n4);
        if (this.mapSize == 0) {
            for (int i = 0; i < 256; ++i) {
                imageProcessor2.setColor(new Color(i, i, i));
                imageProcessor2.moveTo(i, 0);
                imageProcessor2.lineTo(i, n4);
            }
        } else {
            for (int i = 0; i < this.mapSize; ++i) {
                imageProcessor2.setColor(new Color(this.rLUT[i] & 0xFF, this.gLUT[i] & 0xFF, this.bLUT[i] & 0xFF));
                imageProcessor2.moveTo(i, 0);
                imageProcessor2.lineTo(i, n4);
            }
        }
        imageProcessor.insert(imageProcessor2, n, n2);
        imageProcessor.setColor(Color.black);
        imageProcessor.drawRect(n - 1, n2, n3 + 2, n4);
    }

    public static ColorModel createGrayscaleColorModel(boolean bl) {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        if (bl) {
            for (int i = 0; i < 256; ++i) {
                byArray[255 - i] = (byte)i;
                byArray2[255 - i] = (byte)i;
                byArray3[255 - i] = (byte)i;
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                byArray[i] = (byte)i;
                byArray2[i] = (byte)i;
                byArray3[i] = (byte)i;
            }
        }
        return new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }
}

