% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsEspaOrderImages.R
\name{lsEspaOrderImages}
\alias{lsEspaOrderImages}
\title{Make a request to ESPA for pre-processing Landsat images}
\usage{
lsEspaOrderImages(search.res, username, password, product = c("sr",
  "source_metadata"), verbose = FALSE)
}
\arguments{
\item{search.res}{the results from \code{\link{ls7Search}} or
\code{\link{ls8Search}}.}

\item{username}{USGS's `EarthExplorer' username.}

\item{password}{USGS's `EarthExplorer' password.}

\item{product}{the acronym of the requested product (see the details).}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the
running steps and warnings.}
}
\description{
\code{lsEspaOrder} makes a request to the EROS Centre Science Processing
Architecture (ESPA) to further process level-1 Landsat scenes.
}
\details{
Landsat Level-1 images are pre-processed on demand by the EROS Centre Science
Processing Architecture (ESPA). An order is placed to ESPA with the level-1
images that must be pre-processed (\code{search.res} and the requested 
final product (\code{product}). The products are identified by the following
short-names: 
\itemize{
  \item \code{toa}: for top of atmosphere reflectance.
  \item \code{bt}: for brightness temperature (thermal band TOA processing).
  \item \code{sr}: for surface reflectance.
  \item \code{sr_ndvi}: the normalized difference vegetation index from
  surface reflectance imagery.
  \item \code{sr_evi}: the enhanced vegetation index from surface
  reflectance imagery.
  \item \code{sr_savi}: the soil adjusted vegetation index from surface
  reflectance imagery.
  \item \code{sr_msavi}: the modified soil adjusted vegetation index from
  surface reflectance imagery.
  \item \code{sr_ndmi}: the normalized difference moisture index from surface
  reflectance imagery.
  \item \code{sr_nbr}: the normalized burn ratio from surface reflectance
  imagery.
  \item \code{sr_nbr2}: the normalized burn ratio 2 index from surface
  reflectance imagery.
  \item \code{prixel_qa}: for pixel quality assurance.
}
}
\examples{
\dontrun{
src <- paste0(tempdir(),"/Path_for_downloading_folder")
# search Landsat 7 level-1
search.res <- ls7Search(startDate = as.Date("01-01-2017", "\%d-\%m-\%Y"),
                        endDate = as.Date("07-01-2017", "\%d-\%m-\%Y"),
                        lonlat = c(-1.64323, 42.81687),
                        AppRoot = src)
# request to ESPA the pre-pocessing of level-1 images 
# to get the surface reflectance
order <- lsEspaOrderImages(search.res = search.res,
                           username = "username", 
                           password = "password", 
                           product = 'sr',
                           verbose = FALSE)
}
}
