% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs_steps.R
\name{.gibbsStepRAR2}
\alias{.gibbsStepRAR2}
\title{Draws from the posterior of the parameters of the RAR2 cycle equation, conditional on the
states.}
\usage{
.gibbsStepRAR2(Y, parLast, parDistr, varNames)
}
\arguments{
\item{Y}{a \code{Tn x 1} vector.}

\item{parLast}{A \code{3 x 1} vector containing the last draw for amplitude,
mean cycle periodicity, innovation variance (in that order).}

\item{parDistr}{A \code{4 x 3} matrix with prior distribution and box constraints for
the parameters of each variable (the order of the columns is as for parLast). In each
column, the first two entries contain the prior hyperparameters and the last two entries
the upper and lower bound.}

\item{varNames}{A vector with parameter names in the correct order, i.e., amplitude,
mean cycle periodicity, variance.}
}
\value{
A list with the draws.
}
\description{
Draws from the posterior of the parameters of the RAR2 cycle equation, conditional on the
states.
}
\details{
The parameters \eqn{A} and \eqn{\tau} are Beta distributed and the variance
  \eqn{\sigma^2} is Gamma distributed.

The posterior is not available in closed form, instead it is obtained via an ARMS
  step.
}
\keyword{internal}
