% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/uploads.R
\name{list_uploads}
\alias{list_uploads}
\title{Lists uploads to which the user has access to}
\usage{
list_uploads(account.id, webproperty.id, custom.data.source.id,
  start.index = NULL, max.results = NULL, token)
}
\arguments{
\item{account.id}{Account Id for the uploads to retrieve.}

\item{webproperty.id}{Web property Id for the uploads to retrieve.}

\item{custom.data.source.id}{Custom data source Id for uploads to retrieve.}

\item{start.index}{A 1-based index of the first upload to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{The maximum number of uploads to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
Upload collection lists Analytics uploads to which the user has access. Each custom data source can have a set of uploads. Each resource in the upload collection corresponds to a single Analytics data upload.
\item{id}{A unique ID for this upload.}
\item{account.id}{Account Id to which this upload belongs.}
\item{custom.data.source.id}{Custom data source Id to which this data import belongs.}
\item{status}{Upload status. Possible values: PENDING, COMPLETED, FAILED, DELETING, DELETED.}
\item{errors}{Data import errors collection.}
}
\description{
Lists uploads to which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/uploads}{Management API - Uploads}
}
\seealso{
\code{\link{authorize}}

Other Management API: \code{\link{get_custom_dimension}};
  \code{\link{get_custom_metric}};
  \code{\link{get_experiment}}; \code{\link{get_filter}};
  \code{\link{get_goal}}; \code{\link{get_profile}};
  \code{\link{get_unsampled_report}};
  \code{\link{get_upload}}; \code{\link{get_webproperty}};
  \code{\link{list_accounts}};
  \code{\link{list_custom_dimensions}};
  \code{\link{list_custom_metrics}};
  \code{\link{list_custom_sources}};
  \code{\link{list_experiments}};
  \code{\link{list_filters}}; \code{\link{list_goals}};
  \code{\link{list_profiles}}; \code{\link{list_segments}};
  \code{\link{list_unsampled_reports}};
  \code{\link{list_webproperties}}
}

