/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.mutation.common;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.Mutation;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.searchspace.HasDimension;
import freak.core.searchspace.SearchSpace;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;

public class StandardMutation
extends Mutation
implements Configurable,
CompatibleWithDifferentSearchSpaces {
    private double mutationProb;
    private int nextPos;
    private int doubleImprecision;
    private double logbasis;
    private boolean standardMutationProb;

    public StandardMutation(OperatorGraph graph) {
        super(graph);
        if (graph.getSchedule().getGenotypeSearchSpace() instanceof HasDimension) {
            this.setPropertyStandardMutationProb(new Boolean(true));
        }
    }

    public void initialize() {
        super.initialize();
        if (this.standardMutationProb) {
            double p = 1.0 / (double)((HasDimension)((Object)this.getOperatorGraph().getSchedule().getGenotypeSearchSpace())).getDimension();
            this.setNewMutationProb(new Double(p));
        }
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        SearchSpace searchspace = schedule.getGenotypeSearchSpace();
        if (!(searchspace instanceof GeneralString) && !(searchspace instanceof BitString)) {
            throw new UnsupportedEnvironmentException("Wrong searchspace");
        }
    }

    private void setNewMutationProb(Double prob) {
        this.mutationProb = prob;
        this.nextPos = -1;
        this.logbasis = Math.log(1.0 - this.mutationProb);
        this.doubleImprecision = this.logbasis == 0.0 ? Integer.MAX_VALUE : (int)Math.floor(Math.log(Math.pow(2.0, -47.0)) / this.logbasis);
    }

    public void setPropertyMutationProb(Double prob) {
        if (prob >= 0.0 && prob <= 1.0) {
            this.setNewMutationProb(prob);
        }
    }

    public Double getPropertyMutationProb() {
        return new Double(this.mutationProb);
    }

    public String getLongDescriptionForMutationProb() {
        if (this.graph.getSchedule().getGenotypeSearchSpace() instanceof BitString) {
            return "The probability for a bit to flip.";
        }
        return "The probability to alter independently each char.";
    }

    public String getShortDescriptionForMutationProb() {
        return "Mutation probability";
    }

    public void setPropertyStandardMutationProb(Boolean b) {
        this.standardMutationProb = b;
        if (this.standardMutationProb) {
            double p = 1.0 / (double)((HasDimension)((Object)this.getOperatorGraph().getSchedule().getGenotypeSearchSpace())).getDimension();
            this.setNewMutationProb(new Double(p));
        }
    }

    public Boolean getPropertyStandardMutationProb() {
        return new Boolean(this.standardMutationProb);
    }

    public String getShortDescriptionForStandardMutationProb() {
        return "Set mutation prob. to 1/n";
    }

    public String getLongDescriptionForStandardMutationProb() {
        return "If checked, the mutation probability will be automatically set to 1/n, where n is the dimension of the search space.";
    }

    private int savePos(int pos, int max) {
        if (pos > max) {
            this.nextPos = pos - max - 1;
            return -1;
        }
        this.nextPos = -1;
        return pos;
    }

    protected int getNextPosition(int max) {
        if (this.nextPos >= 0) {
            return this.savePos(this.nextPos, max);
        }
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int nextPosition = this.logbasis == 0.0 ? -1 : (int)Math.floor(Math.log(re.raw()) / this.logbasis);
        if (this.doubleImprecision < nextPosition) {
            nextPosition = max > this.doubleImprecision ? this.getNextPosition(max - this.doubleImprecision - 1) + this.doubleImprecision + 1 : -1;
        }
        return this.savePos(nextPosition, max);
    }

    protected Individual doMutation(Individual ind) {
        int dimension = ((HasDimension)((Object)this.graph.getSchedule().getGenotypeSearchSpace())).getDimension();
        int startindex = 0;
        int nextPos = this.getNextPosition(dimension - 1);
        Genotype gt = ind.getGenotype();
        if (gt instanceof BitStringGenotype) {
            BitStringGenotype bs = (BitStringGenotype)((BitStringGenotype)gt).clone();
            while (nextPos != -1) {
                bs.flip(startindex + nextPos);
                nextPos = this.getNextPosition(dimension - (startindex += nextPos + 1) - 1);
            }
            return new Individual(this.graph.getSchedule(), bs, new Individual[]{ind});
        }
        GeneralStringGenotype geno = (GeneralStringGenotype)((GeneralStringGenotype)gt).clone();
        RandomElement re = this.graph.getSchedule().getRandomElement();
        while (nextPos != -1) {
            geno.flip(startindex + nextPos, re);
            nextPos = this.getNextPosition(dimension - (startindex += nextPos + 1) - 1);
        }
        return new Individual(this.graph.getSchedule(), geno, new Individual[]{ind});
    }

    public String getDescription() {
        if (this.graph.getSchedule().getGenotypeSearchSpace() instanceof BitString) {
            return "Each bit is flipped independently with the specified mutation probability.";
        }
        return "Each position is altered independently with the specified mutation probability.";
    }

    public String getName() {
        return "Standard Mutation";
    }
}

