/*
 * Decompiled with CFR 0.152.
 */
package freak.module.mapper.pointset;

import freak.core.control.Schedule;
import freak.core.mapper.AbstractMapper;
import freak.core.population.Genotype;
import freak.core.searchspace.SearchSpace;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import freak.module.searchspace.PointSet;
import freak.module.searchspace.PointSetGenotype;

public class BitStringMapper
extends AbstractMapper {
    private BitString genotypeSearchSpace;

    public BitStringMapper(Schedule schedule) {
        super(schedule);
    }

    public void initialize() {
        super.initialize();
        PointSet space = (PointSet)this.schedule.getPhenotypeSearchSpace();
        try {
            int dimension = space.getDimension();
            this.genotypeSearchSpace = new BitString(this.schedule, dimension);
        }
        catch (IllegalStateException exc) {
            this.genotypeSearchSpace = new BitString(this.schedule);
        }
    }

    public Genotype genotypeToPhenotype(Genotype genotype) {
        PointSet.Point[] ps = ((PointSet)this.schedule.getPhenotypeSearchSpace()).getPoints();
        boolean[] selection = ((BitStringGenotype)genotype).getBooleanArray();
        PointSetGenotype psg = new PointSetGenotype(ps, selection);
        return psg;
    }

    public Genotype phenotypeToGenotype(Genotype phenotype) throws UnsupportedOperationException {
        if (phenotype == null) {
            return null;
        }
        PointSetGenotype psg = (PointSetGenotype)phenotype;
        BitStringGenotype bsg = new BitStringGenotype(psg.getSubSet());
        return bsg;
    }

    public SearchSpace getGenotypeSearchSpace() {
        return this.genotypeSearchSpace;
    }

    public String getDescription() {
        return "Maps Phenotype Point Set to Genotype Bit String.";
    }

    public String getName() {
        return "Point Set to Bit String";
    }
}

