/*
 * Decompiled with CFR 0.152.
 */
package freak.module.parametercontroller;

import freak.core.event.EventListener;
import freak.core.event.GenerationEvent;
import freak.core.event.GenerationEventListener;
import freak.core.graph.OperatorGraph;
import freak.core.graph.UnassignedParameterException;
import freak.core.parametercontroller.AbstractParameterController;
import freak.core.searchspace.HasDimension;

public class DynamicMutationProbability
extends AbstractParameterController
implements GenerationEventListener {
    String name = "Mutation Probabiliy";

    public DynamicMutationProbability(OperatorGraph opGraph) {
        super(opGraph);
        this.addParameter(this.name, Double.class);
    }

    public String getName() {
        return "Dynamic Mutation Probability";
    }

    public String getDescription() {
        return "This controller can be used to simulate a dynamic (1+1)EA. It controls one real valued property which is initialized with 1/n. It is doubled each time a new generation is created. If the property reaches a value larger than 1/2 it is set back to 1/n. (n denotes the dimension of the search space.)";
    }

    public void createEvents() {
        this.getSchedule().getEventController().addEvent((EventListener)this, GenerationEvent.class, this.getSchedule());
    }

    public void generation(GenerationEvent evt) {
        double oldValue = (Double)this.getParameter(this.name);
        double newValue = 2.0 * oldValue;
        if (newValue > 0.5) {
            newValue = this.getSchedule().getGenotypeSearchSpace() instanceof HasDimension ? 1.0 / (double)((HasDimension)((Object)this.getSchedule().getGenotypeSearchSpace())).getDimension() : 0.001;
        }
        this.setParameter(this.name, new Double(newValue));
    }

    public void checkSyntax() throws UnassignedParameterException {
        this.fireExceptionIfParameterIsUnassigned(this.name);
    }
}

