/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset.math;

import freak.module.fitness.pointset.math.EquationSolver;
import freak.module.fitness.pointset.math.matrix.Matrix;
import freak.module.fitness.pointset.math.matrix.Vector;
import freak.module.fitness.pointset.math.matrix.view.NormalView;
import freak.module.fitness.pointset.math.matrix.view.VectorView;

class ConjugrateGradientSolver
extends EquationSolver {
    public ConjugrateGradientSolver(Matrix m, Vector b) throws Exception {
        super(m, b);
    }

    void solve(NormalView pMat, VectorView pB) throws Exception {
        if (!pMat.isSquared()) {
            throw new Error("Matrix must be a squared one");
        }
        int d = pMat.getRow();
        Vector x = new Vector(d);
        VectorView vx = new VectorView(x);
        int i = 0;
        while (i < d) {
            vx.set(i, 1.0);
            ++i;
        }
        Vector r = new Vector(d);
        Vector p = new Vector(d);
        VectorView vr = new VectorView(r);
        VectorView vp = new VectorView(p);
        int i2 = 0;
        while (i2 < d) {
            vr.set(i2, 0.0);
            int j = 0;
            while (j < d) {
                vr.set(i2, vr.get(i2) + pMat.get(i2, j) * vx.get(i2));
                ++j;
            }
            vr.set(i2, pB.get(i2) - vr.get(i2));
            vp.set(i2, vr.get(i2));
            ++i2;
        }
        int iter = 0;
        double delta = 1.0;
        while (delta > 1.0E-6) {
            ++iter;
            double p_mal_Ap_k = 0.0;
            Vector Ap_k = new Vector(d);
            VectorView vAp_k = new VectorView(Ap_k);
            int i3 = 0;
            while (i3 < d) {
                double c = 0.0;
                int j = 0;
                while (j < d) {
                    c += pMat.get(i3, j) * vp.get(j);
                    ++j;
                }
                vAp_k.set(i3, c);
                p_mal_Ap_k += vp.get(i3) * vAp_k.get(i3);
                ++i3;
            }
            double r_mal_r = 0.0;
            int i4 = 0;
            while (i4 < d) {
                r_mal_r += vr.get(i4) * vr.get(i4);
                ++i4;
            }
            double a_k = r_mal_r / p_mal_Ap_k;
            double r_mal_r_neu = 0.0;
            int i5 = 0;
            while (i5 < d) {
                vr.set(i5, vr.get(i5) - a_k * vAp_k.get(i5));
                r_mal_r_neu += vr.get(i5) * vr.get(i5);
                ++i5;
            }
            double b_k = r_mal_r_neu / r_mal_r;
            i5 = 0;
            while (i5 < d) {
                vx.set(i5, vx.get(i5) + a_k * vp.get(i5));
                ++i5;
            }
            i5 = 0;
            while (i5 < d) {
                vp.set(i5, vr.get(i5) + b_k * vp.get(i5));
                ++i5;
            }
            delta = 0.0;
            i5 = 0;
            while (i5 < d) {
                delta += Math.abs(vr.get(i5));
                ++i5;
            }
        }
        this.result = new Vector(d);
        VectorView resView = new VectorView(this.result);
        int i6 = 0;
        while (i6 < d) {
            if (Double.isNaN(vx.get(i6))) {
                vx.set(i6, 0.0);
            }
            resView.set(i6, vx.get(i6));
            ++i6;
        }
    }

    protected boolean willSolveChangeTheMatrix() {
        return false;
    }
}

