/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class Plateau
extends AbstractStaticSingleObjectiveFitnessFunction {
    public Plateau(Schedule schedule) {
        super(schedule);
    }

    public double evaluate(Genotype genotype) {
        boolean isOfSpecialForm;
        BitSet set = ((BitStringGenotype)genotype).getBitSet();
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int cardinality = set.cardinality();
        int leadingOnes = 0;
        while (leadingOnes < n) {
            if (!set.get(leadingOnes)) break;
            ++leadingOnes;
        }
        boolean bl = isOfSpecialForm = cardinality - leadingOnes == 0;
        if (isOfSpecialForm) {
            if (leadingOnes == n) {
                return 2 * n;
            }
            return n + 1;
        }
        return n - cardinality;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        return 2 * ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int dimension = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        BitSet bs = new BitSet(dimension);
        bs.set(0, dimension);
        return new BitStringGenotype(bs, dimension);
    }

    public String getDescription() {
        return "A plateau of search points with the same fitness value has to be crossed to reach the optimum. The plateau consists of all individuals with all ones in the left part and all zeroes in the right part of the genotype. An exception is the global optimum: the individual containing only ones gets a fitness value of 2n.\nAll individuals on the plateau get fitness n+1, the other individuals get fitness n - OneMax, thus giving hints to reach the plateau at the opposite side of the optimum.";
    }

    public String getName() {
        return "Plateau";
    }
}

