% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plotVarFreq}
\alias{plotVarFreq}
\title{Variable Frequency Plot}
\usage{
plotVarFreq(varFrequency, thd = 0.4, color = "blue", hcol = "red")
}
\arguments{
\item{varFrequency}{a numeric vector with the probabilities of selection of each input variable}

\item{thd}{a numeric value that indicates the lower limit of probability of variables to be represented. The default
value is 0.4 (40\%)}

\item{color}{the color of the graph}

\item{hcol}{the color of the horizontal line, indicating the lower limit of the probability of selection of variables}
}
\description{
This function plots the probability of selection of each variable (metabolite) as the proportion of times that is selected
by AUCRF method
}
\examples{
## data(cachexiaData)
## rf.aucv1 <- aucMCV(cachexiaData, ref_level = 'control')
## plotVarFreq(varFrequency = rf.aucv1$Psel,  thd=0.55)
}
\author{
Piergiorgio Palla
}

