% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.mds}
\alias{plot.mds}
\title{Multi-dimensional Scaling (MDS) Plot}
\usage{
\method{plot}{mds}(mds_obj, xrange, yrange)
}
\arguments{
\item{mds_obj}{an object of class mds}

\item{xrange}{a vector of two elements indicating the interval along the x-axis in which we want to display the names of the samples}

\item{yrange}{a vector of two elements indicating the interval along the y-axis in which we want to display the names of the samples}
}
\description{
This function plots the scaling coordinates of the proximity matrix from random forest.
}
\details{
From the trained model we can get the dissimilarity matrix  ** 1 - prox(i,j) **
The entries of this matrix can be seen as squared distances in a Euclidean high dimensional space.
After having calculated scaling coordinates, we can project the data onto a lower dimensional space, preserving
(as much as possible) the distances between the orginal points.
This plot can be useful for discovering patterns in data.
}
\examples{
## data(cachexiaData)
## params = list(ntree = 1000, mtry = round(sqrt(ncol(cachexiaData) -2)), seed = 1234)
## mds_obj <- mds(cachexiaData, opt = params)
## plot.mds(mds_obj = mds_obj)
}

