/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique.ihm;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javalain.algorithmegenetique.ParametreAG;
import javalain.algorithmegenetique.ihm.ControleAlgoG;
import javalain.algorithmegenetique.ihm.composant.JCheckBoxEA;
import javalain.algorithmegenetique.ihm.composant.JLabelEAPar;
import javalain.algorithmegenetique.ihm.composant.JLabelEAPres;
import javalain.algorithmegenetique.ihm.composant.JRadioButtonEA;
import javalain.algorithmegenetique.ihm.composant.JTextFieldEA;
import javalain.algorithmegenetique.ihm.composant.TitledBorderEA;
import javalain.algorithmegenetique.ihm.controle.ListeNbPartTournoi;
import javalain.algorithmegenetique.ihm.controle.SliderCroisement;
import javalain.algorithmegenetique.ihm.controle.SliderMutation;
import javalain.algorithmegenetique.ihm.controle.TexteAlpha;
import javalain.algorithmegenetique.ihm.controle.TexteFrontiere;
import javalain.algorithmegenetique.ihm.controle.TexteNbMeilleur;
import javalain.algorithmegenetique.ihm.controle.TexteNbOverlap;
import javalain.algorithmegenetique.ihm.controle.TexteTdom;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import util.GuiUtils;

public class PanneauModeEvolution
extends JPanel
implements ActionListener {
    private JPanel jpAlgorithme;
    private TitledBorderEA tbAlgorithme;
    private JLabelEAPres lblSelection;
    private JRadioButtonEA rbRang;
    private JRadioButtonEA rbRoulette;
    private JRadioButtonEA rbResteStochastique;
    private JRadioButtonEA rbTournoi;
    private ListeNbPartTournoi cbNbPartTournoi1;
    private JPanel jpTournoi;
    private JPanel jpTournoiSimple;
    private JPanel jpTournoiPareto;
    private TexteTdom textTdom;
    private JLabelEAPres lblDiversite;
    private JCheckBoxEA cbScaling;
    private JCheckBoxEA cbSharing;
    private JCheckBoxEA cbCrowding;
    private JCheckBoxEA cbCroisRestreint;
    private JLabelEAPres lblElitisme;
    private JCheckBoxEA cbElitisme;
    private JLabelEAPres lblRemplacement;
    private JPanel jpRemplacement;
    private JPanel jpWithoutOverlap;
    private JPanel jpWithOverlap;
    private JRadioButtonEA rbOverRandom;
    private JRadioButtonEA rbOverWorst;
    private JRadioButtonEA rbOverTournoi;
    private JRadioButtonEA rbOverOld;
    private JRadioButtonEA rbOverCustom;
    private JLabelEAPar lblWhitoutOver;
    private JLabelEAPres lblTauxMut;
    private JLabelEAPres lblTauxCrois;
    private SliderMutation sliderMut;
    private SliderCroisement sliderCrois;
    private JTextFieldEA txtMut;
    private JTextFieldEA txtCrois;
    private JLabelEAPres lblParamVoisin;
    private JLabelEAPar lblAlpha;
    private JLabelEAPar lblFrontiere;
    private TexteAlpha textAlpha;
    private TexteFrontiere textFrontiere;
    private JLabelEAPres lblOverlap;
    private JLabelEAPar lblNbOverlap;
    private TexteNbOverlap textNbOverlap;
    private JLabelEAPres lblElitisme2;
    private JLabelEAPar lblNbMeilleurs;
    private TexteNbMeilleur textNbMeilleurs;
    private JLabelEAPar lblNbMeilleurs2;
    private ControleAlgoG ctrlAG;

    public PanneauModeEvolution(ControleAlgoG c) {
        this.ctrlAG = c;
        this.setLayout(new BoxLayout(this, 0));
        this.jpAlgorithme = new JPanel();
        this.tbAlgorithme = new TitledBorderEA("Algorithme");
        this.jpAlgorithme.setBorder(this.tbAlgorithme);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.jpAlgorithme.setLayout(gb);
        int ligne = 0;
        this.lblSelection = new JLabelEAPres("S\u00e9lection");
        this.lblSelection.setEnabled(false);
        gbc.gridy = ligne++;
        gbc.gridwidth = 1;
        gbc.insets = GuiUtils.INSETS_0000;
        gbc.anchor = 17;
        gb.setConstraints(this.lblSelection, gbc);
        this.jpAlgorithme.add(this.lblSelection);
        ButtonGroup group = new ButtonGroup();
        this.rbRang = new JRadioButtonEA("Rang");
        this.rbRang.setEnabled(false);
        this.rbRang.addActionListener(this);
        group.add(this.rbRang);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0500;
        gb.setConstraints(this.rbRang, gbc);
        this.jpAlgorithme.add(this.rbRang);
        this.rbRoulette = new JRadioButtonEA("Roulette pip\u00e9e");
        this.rbRoulette.setEnabled(false);
        this.rbRoulette.addActionListener(this);
        group.add(this.rbRoulette);
        gbc.gridy = ligne++;
        gb.setConstraints(this.rbRoulette, gbc);
        this.jpAlgorithme.add(this.rbRoulette);
        this.rbResteStochastique = new JRadioButtonEA("Reste stochastique");
        this.rbResteStochastique.setEnabled(false);
        this.rbResteStochastique.addActionListener(this);
        group.add(this.rbResteStochastique);
        gbc.gridy = ligne++;
        gb.setConstraints(this.rbResteStochastique, gbc);
        this.jpAlgorithme.add(this.rbResteStochastique);
        this.jpTournoi = new JPanel(GuiUtils.FL_LEFT_00);
        gbc.gridy = ligne++;
        gb.setConstraints(this.jpTournoi, gbc);
        this.jpTournoiSimple = new JPanel(GuiUtils.FL_LEFT_00);
        this.jpTournoiSimple.setVisible(true);
        this.rbTournoi = new JRadioButtonEA("Tournoi");
        this.rbTournoi.setEnabled(false);
        this.rbTournoi.addActionListener(this);
        group.add(this.rbTournoi);
        this.rbTournoi.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanneauModeEvolution.this.rbTournoi.isSelected() && PanneauModeEvolution.this.rbTournoi.isEnabled()) {
                    PanneauModeEvolution.this.cbNbPartTournoi1.setEnabled(true);
                } else {
                    PanneauModeEvolution.this.cbNbPartTournoi1.setEnabled(false);
                }
            }
        });
        this.jpTournoiSimple.add(this.rbTournoi);
        this.cbNbPartTournoi1 = new ListeNbPartTournoi(this.ctrlAG);
        this.cbNbPartTournoi1.setEnabled(false);
        this.jpTournoiSimple.add(this.cbNbPartTournoi1);
        this.jpTournoi.add(this.jpTournoiSimple);
        this.jpTournoiPareto = new JPanel(GuiUtils.FL_LEFT_00);
        this.jpTournoiPareto.setVisible(false);
        JRadioButtonEA rb = new JRadioButtonEA("<html>T<sub>dom</sub></html>");
        rb.setToolTipText("Tournoi de dominance");
        rb.setSelected(true);
        rb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JRadioButtonEA)e.getSource()).setSelected(true);
            }
        });
        rb.setMargin(new Insets(0, 2, 0, 2));
        this.jpTournoiPareto.add(rb);
        this.textTdom = new TexteTdom(this.ctrlAG);
        this.jpTournoiPareto.add(this.textTdom);
        this.jpTournoi.add(this.jpTournoiPareto);
        this.jpAlgorithme.add(this.jpTournoi);
        this.lblDiversite = new JLabelEAPres("Diversit\u00e9");
        this.lblDiversite.setEnabled(false);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints(this.lblDiversite, gbc);
        this.jpAlgorithme.add(this.lblDiversite);
        this.cbScaling = new JCheckBoxEA("Scaling");
        this.cbScaling.setToolTipText("Mise \u00e0 l'\u00e9chelle des notes");
        this.cbScaling.setEnabled(false);
        this.cbScaling.addActionListener(this);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0500;
        gb.setConstraints(this.cbScaling, gbc);
        this.jpAlgorithme.add(this.cbScaling);
        this.cbSharing = new JCheckBoxEA("Sharing");
        this.cbSharing.setToolTipText("Heuristique de partage");
        this.cbSharing.setEnabled(false);
        this.cbSharing.addActionListener(this);
        gbc.gridy = ligne++;
        gb.setConstraints(this.cbSharing, gbc);
        this.cbSharing.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanneauModeEvolution.this.cbSharing.isSelected()) {
                    PanneauModeEvolution.this.lblParamVoisin.setEnabled(true);
                    PanneauModeEvolution.this.lblAlpha.setEnabled(true);
                    PanneauModeEvolution.this.textAlpha.setEnabled(true);
                    PanneauModeEvolution.this.lblFrontiere.setEnabled(true);
                    PanneauModeEvolution.this.textFrontiere.setEnabled(true);
                } else {
                    PanneauModeEvolution.this.lblParamVoisin.setEnabled(false);
                    PanneauModeEvolution.this.lblAlpha.setEnabled(false);
                    PanneauModeEvolution.this.textAlpha.setEnabled(false);
                    PanneauModeEvolution.this.lblFrontiere.setEnabled(false);
                    PanneauModeEvolution.this.textFrontiere.setEnabled(false);
                }
            }
        });
        this.jpAlgorithme.add(this.cbSharing);
        this.cbCrowding = new JCheckBoxEA("Crowding");
        this.cbCrowding.setToolTipText("Heuristique de remplacement");
        this.cbCrowding.setEnabled(false);
        this.cbCrowding.addActionListener(this);
        gbc.gridy = ligne++;
        gb.setConstraints(this.cbCrowding, gbc);
        this.jpAlgorithme.add(this.cbCrowding);
        this.cbCroisRestreint = new JCheckBoxEA("Croisement restreint");
        this.cbCroisRestreint.setEnabled(false);
        this.cbCroisRestreint.addActionListener(this);
        gbc.gridy = ligne++;
        gb.setConstraints(this.cbCroisRestreint, gbc);
        this.jpAlgorithme.add(this.cbCroisRestreint);
        Component cc = Box.createVerticalStrut(54);
        gbc.gridy = ligne;
        gbc.insets = GuiUtils.INSETS_0000;
        gb.setConstraints(cc, gbc);
        this.jpAlgorithme.add(cc);
        ligne = 0;
        this.lblElitisme = new JLabelEAPres("Elitisme");
        this.lblElitisme.setEnabled(false);
        gbc.gridx = 1;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0000;
        gb.setConstraints(this.lblElitisme, gbc);
        this.jpAlgorithme.add(this.lblElitisme);
        this.cbElitisme = new JCheckBoxEA("Copie des meilleurs");
        this.cbElitisme.setEnabled(false);
        this.cbElitisme.addActionListener(this);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0500;
        gb.setConstraints(this.cbElitisme, gbc);
        this.cbElitisme.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PanneauModeEvolution.this.cbElitisme.isSelected()) {
                    PanneauModeEvolution.this.lblElitisme2.setEnabled(false);
                    PanneauModeEvolution.this.lblNbMeilleurs.setEnabled(false);
                    PanneauModeEvolution.this.textNbMeilleurs.setEnabled(false);
                    PanneauModeEvolution.this.lblNbMeilleurs2.setEnabled(false);
                }
            }
        });
        this.jpAlgorithme.add(this.cbElitisme);
        this.lblRemplacement = new JLabelEAPres("Remplacement");
        this.lblRemplacement.setEnabled(false);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints(this.lblRemplacement, gbc);
        this.jpAlgorithme.add(this.lblRemplacement);
        this.jpRemplacement = new JPanel(GuiUtils.FL_LEFT_00);
        gbc.gridy = ligne;
        gbc.insets = GuiUtils.INSETS_0500;
        gbc.gridheight = 0;
        gbc.fill = 3;
        gb.setConstraints(this.jpRemplacement, gbc);
        this.jpAlgorithme.add(this.jpRemplacement);
        this.jpWithoutOverlap = new JPanel(new FlowLayout(0, 4, 0));
        this.jpWithoutOverlap.setVisible(false);
        this.lblWhitoutOver = new JLabelEAPar("<html>Les enfants g\u00e9n\u00e9r\u00e9s<br>remplacent les parents<br>pour former la<br>g\u00e9n\u00e9ration suivante.</html>");
        this.jpWithoutOverlap.add(this.lblWhitoutOver);
        this.jpRemplacement.add(this.jpWithoutOverlap);
        this.jpRemplacement.setPreferredSize(this.jpWithoutOverlap.getPreferredSize());
        this.jpWithOverlap = new JPanel(new GridLayout(5, 1, 0, 0));
        this.jpWithOverlap.setVisible(false);
        this.jpWithOverlap.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                PanneauModeEvolution.this.lblOverlap.setEnabled(true);
                PanneauModeEvolution.this.lblNbOverlap.setEnabled(true);
                PanneauModeEvolution.this.textNbOverlap.setEnabled(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                PanneauModeEvolution.this.lblOverlap.setEnabled(false);
                PanneauModeEvolution.this.lblNbOverlap.setEnabled(false);
                PanneauModeEvolution.this.textNbOverlap.setEnabled(false);
            }
        });
        group = new ButtonGroup();
        this.rbOverRandom = new JRadioButtonEA("Al\u00e9atoire");
        this.rbOverRandom.addActionListener(this);
        group.add(this.rbOverRandom);
        this.jpWithOverlap.add(this.rbOverRandom);
        this.rbOverWorst = new JRadioButtonEA("Les plus mauvais");
        this.rbOverWorst.addActionListener(this);
        group.add(this.rbOverWorst);
        this.jpWithOverlap.add(this.rbOverWorst);
        this.rbOverTournoi = new JRadioButtonEA("Tournoi invers\u00e9");
        this.rbOverTournoi.addActionListener(this);
        group.add(this.rbOverTournoi);
        this.jpWithOverlap.add(this.rbOverTournoi);
        this.rbOverOld = new JRadioButtonEA("Les plus vieux");
        this.rbOverOld.setEnabled(false);
        this.rbOverOld.addActionListener(this);
        group.add(this.rbOverOld);
        this.jpWithOverlap.add(this.rbOverOld);
        this.rbOverCustom = new JRadioButtonEA("Utilisateur");
        this.rbOverCustom.setEnabled(false);
        this.rbOverCustom.addActionListener(this);
        this.jpWithOverlap.add(this.rbOverOld);
        group.add(this.rbOverCustom);
        this.jpWithOverlap.add(this.rbOverCustom);
        this.jpRemplacement.add(this.jpWithOverlap);
        this.add(this.jpAlgorithme);
        JPanel jpParam = new JPanel();
        TitledBorderEA tb = new TitledBorderEA("Param\u00e8tres");
        jpParam.setBorder(tb);
        gb = new GridBagLayout();
        gbc = new GridBagConstraints();
        jpParam.setLayout(gb);
        ligne = 0;
        this.lblTauxMut = new JLabelEAPres("Taux de mutation");
        this.lblTauxMut.setEnabled(false);
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.gridwidth = 3;
        gbc.insets = GuiUtils.INSETS_0000;
        gbc.anchor = 17;
        gb.setConstraints(this.lblTauxMut, gbc);
        jpParam.add(this.lblTauxMut);
        this.txtMut = new JTextFieldEA(3);
        this.txtMut.setEnabled(false);
        this.sliderMut = new SliderMutation(this.ctrlAG, this.txtMut);
        gbc.gridy = ligne;
        gbc.gridwidth = 2;
        gbc.insets = GuiUtils.INSETS_5500;
        gbc.anchor = 13;
        gb.setConstraints(this.sliderMut, gbc);
        jpParam.add(this.sliderMut);
        gbc.gridx = 2;
        gbc.gridy = ligne++;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gb.setConstraints(this.txtMut, gbc);
        jpParam.add(this.txtMut);
        this.lblTauxCrois = new JLabelEAPres("Taux de croisement");
        this.lblTauxCrois.setEnabled(false);
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.gridwidth = 3;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints(this.lblTauxCrois, gbc);
        jpParam.add(this.lblTauxCrois);
        this.txtCrois = new JTextFieldEA(3);
        this.txtCrois.setEnabled(false);
        this.sliderCrois = new SliderCroisement(this.ctrlAG, this.txtCrois);
        gbc.gridy = ligne;
        gbc.gridwidth = 2;
        gbc.insets = GuiUtils.INSETS_5500;
        gbc.anchor = 13;
        gb.setConstraints(this.sliderCrois, gbc);
        jpParam.add(this.sliderCrois);
        gbc.gridx = 2;
        gbc.gridy = ligne++;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gb.setConstraints(this.txtCrois, gbc);
        jpParam.add(this.txtCrois);
        this.lblParamVoisin = new JLabelEAPres("Param\u00e8tres de voisinage");
        this.lblParamVoisin.setEnabled(false);
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.gridwidth = 3;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints(this.lblParamVoisin, gbc);
        jpParam.add(this.lblParamVoisin);
        this.lblAlpha = new JLabelEAPar("Alpha");
        this.lblAlpha.setEnabled(false);
        gbc.gridy = ligne;
        gbc.gridwidth = 1;
        gbc.insets = GuiUtils.INSETS_5500;
        gbc.anchor = 13;
        gb.setConstraints(this.lblAlpha, gbc);
        jpParam.add(this.lblAlpha);
        this.textAlpha = new TexteAlpha(this.ctrlAG);
        this.textAlpha.setEnabled(false);
        gbc.gridx = 1;
        gbc.gridy = ligne++;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gb.setConstraints(this.textAlpha, gbc);
        jpParam.add(this.textAlpha);
        this.lblFrontiere = new JLabelEAPar("<html>Sigma<sub>share</sub></html>");
        this.lblFrontiere.setEnabled(false);
        gbc.gridx = 0;
        gbc.gridy = ligne;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gb.setConstraints(this.lblFrontiere, gbc);
        this.lblFrontiere.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (PanneauModeEvolution.this.lblFrontiere.isEnabled()) {
                    PanneauModeEvolution.this.lblFrontiere.setForeground(Color.black);
                } else {
                    PanneauModeEvolution.this.lblFrontiere.setForeground(GuiUtils.GRIS_153);
                }
            }
        });
        jpParam.add(this.lblFrontiere);
        this.textFrontiere = new TexteFrontiere(this.ctrlAG);
        this.textFrontiere.setEnabled(false);
        gbc.gridx = 1;
        gbc.gridy = ligne++;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gb.setConstraints(this.textFrontiere, gbc);
        jpParam.add(this.textFrontiere);
        this.lblOverlap = new JLabelEAPres("Remplacement");
        this.lblOverlap.setEnabled(false);
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.gridwidth = 3;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints(this.lblOverlap, gbc);
        jpParam.add(this.lblOverlap);
        this.lblNbOverlap = new JLabelEAPar("Taille de p''");
        this.lblNbOverlap.setEnabled(false);
        gbc.gridy = ligne++;
        gbc.gridwidth = 1;
        gbc.insets = GuiUtils.INSETS_5500;
        gbc.anchor = 13;
        gb.setConstraints(this.lblNbOverlap, gbc);
        jpParam.add(this.lblNbOverlap);
        this.textNbOverlap = new TexteNbOverlap(this.ctrlAG);
        this.textNbOverlap.setEnabled(false);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gb.setConstraints(this.textNbOverlap, gbc);
        jpParam.add(this.textNbOverlap);
        this.lblElitisme2 = new JLabelEAPres("Elitisme");
        this.lblElitisme2.setEnabled(false);
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.gridwidth = 3;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints(this.lblElitisme2, gbc);
        jpParam.add(this.lblElitisme2);
        this.lblNbMeilleurs = new JLabelEAPar("Copie les");
        this.lblNbMeilleurs.setEnabled(false);
        gbc.gridy = ligne;
        gbc.gridwidth = 1;
        gbc.insets = GuiUtils.INSETS_5500;
        gbc.anchor = 13;
        gb.setConstraints(this.lblNbMeilleurs, gbc);
        jpParam.add(this.lblNbMeilleurs);
        this.textNbMeilleurs = new TexteNbMeilleur(this.ctrlAG);
        this.textNbMeilleurs.setEnabled(false);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gb.setConstraints(this.textNbMeilleurs, gbc);
        jpParam.add(this.textNbMeilleurs);
        this.lblNbMeilleurs2 = new JLabelEAPar("meilleurs");
        this.lblNbMeilleurs2.setEnabled(false);
        gbc.gridx = 2;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints(this.lblNbMeilleurs2, gbc);
        jpParam.add(this.lblNbMeilleurs2);
        cc = Box.createVerticalStrut(25);
        gbc.gridy = ligne;
        gbc.insets = GuiUtils.INSETS_0000;
        gb.setConstraints(cc, gbc);
        jpParam.add(cc);
        this.add(jpParam);
    }

    public void setAlgorithme(String s) {
        if (s != this.tbAlgorithme.getTitle()) {
            this.tbAlgorithme.setTitle(s);
            this.jpAlgorithme.repaint();
            if (s.equals("Generational GA")) {
                this.lblSelection.setEnabled(true);
                this.rbRang.setEnabled(true);
                this.rbRoulette.setEnabled(true);
                this.rbResteStochastique.setEnabled(true);
                this.rbTournoi.setEnabled(true);
                this.jpTournoiPareto.setVisible(false);
                this.jpTournoiSimple.setVisible(true);
                this.lblDiversite.setEnabled(true);
                this.cbScaling.setEnabled(true);
                this.cbSharing.setEnabled(true);
                this.cbCroisRestreint.setEnabled(true);
                this.lblElitisme.setEnabled(true);
                this.cbElitisme.setEnabled(true);
                this.lblRemplacement.setEnabled(true);
                this.jpWithOverlap.setVisible(false);
                this.jpWithoutOverlap.setVisible(true);
                this.lblTauxMut.setEnabled(true);
                this.sliderMut.setEnabled(true);
                this.txtMut.setEnabled(true);
                this.lblTauxCrois.setEnabled(true);
                this.sliderCrois.setEnabled(true);
                this.txtCrois.setEnabled(true);
            } else if (s.equals("Steady-State GA")) {
                this.lblSelection.setEnabled(true);
                this.rbRang.setEnabled(true);
                this.rbRoulette.setEnabled(true);
                this.rbResteStochastique.setEnabled(true);
                this.rbTournoi.setEnabled(true);
                this.jpTournoiPareto.setVisible(false);
                this.jpTournoiSimple.setVisible(true);
                this.lblDiversite.setEnabled(true);
                this.cbScaling.setEnabled(false);
                this.cbSharing.setEnabled(true);
                this.cbCroisRestreint.setEnabled(true);
                this.lblElitisme.setEnabled(false);
                this.cbElitisme.setEnabled(false);
                this.lblRemplacement.setEnabled(true);
                this.jpWithoutOverlap.setVisible(false);
                this.jpWithOverlap.setVisible(true);
                switch (this.ctrlAG.getEvolution().getPopulation().getParametreAG().getRemplacement()) {
                    case 21: {
                        this.rbOverRandom.setSelected(true);
                        break;
                    }
                    case 23: {
                        this.rbOverTournoi.setSelected(true);
                        break;
                    }
                    case 24: {
                        this.rbOverOld.setSelected(true);
                        break;
                    }
                    case 25: {
                        this.rbOverCustom.setSelected(true);
                        break;
                    }
                    default: {
                        this.rbOverWorst.setSelected(true);
                    }
                }
                this.lblTauxMut.setEnabled(true);
                this.sliderMut.setEnabled(true);
                this.txtMut.setEnabled(true);
                this.lblTauxCrois.setEnabled(false);
                this.sliderCrois.setEnabled(false);
                this.txtCrois.setEnabled(false);
            } else if (!s.equals("Evolution Strategy")) {
                if (s.equals("MultiObjective GA")) {
                    this.lblSelection.setEnabled(true);
                    this.rbRang.setEnabled(true);
                    this.rbRoulette.setEnabled(false);
                    this.rbResteStochastique.setEnabled(false);
                    this.rbTournoi.setEnabled(false);
                    this.jpTournoiPareto.setVisible(false);
                    this.jpTournoiSimple.setVisible(true);
                    this.lblDiversite.setEnabled(true);
                    this.cbScaling.setEnabled(true);
                    this.cbSharing.setEnabled(true);
                    this.cbCroisRestreint.setEnabled(true);
                    this.lblElitisme.setEnabled(false);
                    this.cbElitisme.setEnabled(false);
                    this.lblRemplacement.setEnabled(true);
                    this.jpWithOverlap.setVisible(false);
                    this.jpWithoutOverlap.setVisible(true);
                    this.lblTauxMut.setEnabled(true);
                    this.sliderMut.setEnabled(true);
                    this.txtMut.setEnabled(true);
                    this.lblTauxCrois.setEnabled(true);
                    this.sliderCrois.setEnabled(true);
                    this.txtCrois.setEnabled(true);
                } else if (s.equals("Niched Pareto GA")) {
                    this.lblSelection.setEnabled(false);
                    this.rbRang.setEnabled(false);
                    this.rbRoulette.setEnabled(false);
                    this.rbResteStochastique.setEnabled(false);
                    this.rbTournoi.setEnabled(false);
                    this.jpTournoiSimple.setVisible(false);
                    this.jpTournoiPareto.setVisible(true);
                    this.lblDiversite.setEnabled(true);
                    this.cbScaling.setEnabled(true);
                    this.cbSharing.setEnabled(false);
                    this.cbCroisRestreint.setEnabled(true);
                    this.lblElitisme.setEnabled(false);
                    this.cbElitisme.setEnabled(false);
                    this.lblRemplacement.setEnabled(true);
                    this.jpWithOverlap.setVisible(false);
                    this.jpWithoutOverlap.setVisible(true);
                    this.lblTauxMut.setEnabled(true);
                    this.sliderMut.setEnabled(true);
                    this.txtMut.setEnabled(true);
                    this.lblTauxCrois.setEnabled(true);
                    this.sliderCrois.setEnabled(true);
                    this.txtCrois.setEnabled(true);
                } else if (!s.equals("Nondominated Sorting GA 2")) {
                    this.lblSelection.setEnabled(true);
                    this.rbRang.setEnabled(true);
                    this.rbRoulette.setEnabled(true);
                    this.rbResteStochastique.setEnabled(true);
                    this.rbTournoi.setEnabled(true);
                    this.jpTournoiPareto.setVisible(false);
                    this.jpTournoiSimple.setVisible(true);
                    this.lblDiversite.setEnabled(true);
                    this.cbScaling.setEnabled(false);
                    this.cbSharing.setEnabled(false);
                    this.cbCroisRestreint.setEnabled(true);
                    this.lblElitisme.setEnabled(false);
                    this.cbElitisme.setEnabled(false);
                    this.lblRemplacement.setEnabled(true);
                    this.jpWithOverlap.setVisible(false);
                    this.jpWithoutOverlap.setVisible(true);
                    this.lblTauxMut.setEnabled(true);
                    this.sliderMut.setEnabled(true);
                    this.txtMut.setEnabled(true);
                    this.lblTauxCrois.setEnabled(true);
                    this.sliderCrois.setEnabled(true);
                    this.txtCrois.setEnabled(true);
                }
            }
        }
        ParametreAG p = this.ctrlAG.getEvolution().getPopulation().getParametreAG();
        this.setValeurs(p.getTauxMutation(), p.getTauxCroisement(), p.getSelection(), p.getNbPartTournoi(), p.getScaling(), p.getSharing(), p.getAlpha(), p.getSigmaShare(), p.getCrowding(), p.getCroisementRestreint(), p.getElitisme(), p.getNbMeilleurs(), p.getNbOverlap(), p.getTdom());
    }

    public void setValeurs(double taux_mut, double taux_crois, int selection, int nb_part, boolean scaling, boolean sharing, double alpha, double sigma, boolean crowding, boolean crois_restreint, boolean elitisme, int nb_meilleurs, int nb_over, int t_dom) {
        this.sliderMut.setValeur(taux_mut);
        this.sliderCrois.setValeur(taux_crois);
        switch (selection) {
            case 0: {
                this.rbRang.setSelected(true);
                break;
            }
            case 2: {
                this.rbRoulette.setSelected(true);
                break;
            }
            case 3: {
                this.rbResteStochastique.setSelected(true);
                break;
            }
            default: {
                this.rbTournoi.setSelected(true);
            }
        }
        this.cbNbPartTournoi1.setValeur(nb_part);
        this.cbScaling.setSelected(scaling);
        this.cbSharing.setSelected(sharing);
        this.textAlpha.setValeur(alpha);
        this.textFrontiere.setValeur(sigma);
        this.cbCrowding.setSelected(crowding);
        this.cbCroisRestreint.setSelected(crois_restreint);
        this.cbElitisme.setSelected(elitisme);
        this.textNbMeilleurs.setValeur(nb_meilleurs);
        this.textNbOverlap.setValeur(nb_over);
        this.textTdom.setValeur(t_dom);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cde = e.getActionCommand();
        if (cde == "Rang") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setSelection(0);
        }
        if (cde == "Roulette pip\u00e9e") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setSelection(2);
        }
        if (cde == "Reste stochastique") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setSelection(3);
        }
        if (cde == "Tournoi") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setSelection(1);
        }
        if (cde == "Scaling") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setScaling(this.cbScaling.isSelected());
        }
        if (cde == "Sharing") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setSharing(this.cbSharing.isSelected());
        }
        if (cde == "Crowding") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setCrowding(this.cbCrowding.isSelected());
        }
        if (cde == "Croisement restreint") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setCroisementRestreint(this.cbCroisRestreint.isSelected());
        }
        if (cde == "Copie des meilleurs") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setElitisme(this.cbElitisme.isSelected());
        }
        if (cde == "Al\u00e9atoire") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setRemplacement(21);
        }
        if (cde == "Les plus mauvais") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setRemplacement(22);
        }
        if (cde == "Tournoi invers\u00e9") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setRemplacement(23);
        }
        if (cde == "Les plus vieux") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setRemplacement(24);
        }
        if (cde == "Utilisateur") {
            this.ctrlAG.getEvolution().getPopulation().getParametreAG().setRemplacement(25);
        }
    }
}

