/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique;

import java.io.Serializable;

public class DomaineReel
implements Serializable {
    private double min;
    private double max;
    private double taille;
    private double rayon;

    public DomaineReel(double min, double max) {
        if (min > max) {
            throw new RuntimeException("DomaineReel, DomaineReel (double min, double max) : min > max.");
        }
        this.min = min;
        this.max = max;
        this.taille = max - min;
        this.rayon = this.taille < 1000.0 ? this.taille / 150.0 : Math.log(this.taille);
    }

    public DomaineReel(double min, double max, double rayon) {
        if (min > max) {
            throw new RuntimeException("DomaineReel, DomaineReel (double min, double max, double rayon) : min > max.");
        }
        this.min = min;
        this.max = max;
        this.taille = max - min;
        this.rayon = rayon;
    }

    public void setMin(double nb) {
        if (nb > this.max) {
            throw new RuntimeException("DomaineReel, setMin (double nb) : nb est > a la borne superieure du domaine.");
        }
        this.min = nb;
        this.taille = this.max - nb;
    }

    public void setMax(double nb) {
        if (nb < this.min) {
            throw new RuntimeException("DomaineReel, setMax (double nb) : nb est < a la borne inferieure du domaine.");
        }
        this.max = nb;
        this.taille = nb - this.min;
    }

    public void setRayon(double nb) {
        this.rayon = nb;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getRayon() {
        return this.rayon;
    }

    public double getTaille() {
        return this.taille;
    }
}

