/*
 * Decompiled with CFR 0.152.
 */
package indice;

import indice.Indice;
import javalain.math.Calcul;
import math.Matrice;

public final class FriedmanTukey
extends Indice {
    private final double H = 3.12 * Math.pow(this.N, -0.16666666666666666);
    private final double CTE = (double)(this.N * this.N) * this.H * this.H;
    private final double c0 = 1.09375;

    public FriedmanTukey(Matrice matrice) {
        super(matrice);
    }

    @Override
    public double calcul(double[] a) {
        ++this.nbEvaluation;
        double somme_i = 0.0;
        for (int i = 0; i < this.N; ++i) {
            double[] Xi = this.matrice.ligne(i);
            double somme_j = 0.0;
            for (int j = 0; j < i - 1; ++j) {
                double[] Xj = this.matrice.ligne(j);
                somme_j += this.fct_K(Calcul.produitScalaireVecteur(a, Calcul.differenceVecteur(Xi, Xj)) / this.H);
            }
            somme_i += 0.5 + 2.0 * somme_j;
        }
        return somme_i / this.CTE;
    }

    private double fct_K(double d) {
        if (Math.abs(d) < this.H) {
            return 1.09375 * Calcul.pow3(1.0 - d * d);
        }
        return 0.0;
    }
}

