/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import umontreal.iro.lecuyer.stat.StatProbe;
import umontreal.iro.lecuyer.stat.list.ArrayOfObservationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfStatProbes<E extends StatProbe>
implements Cloneable,
List<E>,
RandomAccess {
    private List<E> probes;
    private List<ArrayOfObservationListener> listeners = new ArrayList<ArrayOfObservationListener>();
    protected boolean collect = true;
    protected boolean broadcast = false;
    protected String name;

    public ListOfStatProbes() {
        this.probes = new ArrayList();
    }

    public ListOfStatProbes(String string) {
        this.probes = new ArrayList();
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isModifiable() {
        return this.probes instanceof ArrayList;
    }

    public void setUnmodifiable() {
        if (this.isModifiable()) {
            this.probes = Collections.unmodifiableList(this.probes);
        }
    }

    public void init() {
        for (StatProbe statProbe : this.probes) {
            if (statProbe == null) continue;
            statProbe.init();
        }
    }

    public void sum(double[] dArray) {
        if (dArray.length != this.size()) {
            throw new IllegalArgumentException("Invalid length of the given array: given length is " + dArray.length + ", required length is " + this.size());
        }
        int n = 0;
        for (StatProbe statProbe : this.probes) {
            dArray[n++] = statProbe == null ? Double.NaN : statProbe.sum();
        }
    }

    public void average(double[] dArray) {
        if (dArray.length != this.size()) {
            throw new IllegalArgumentException("Invalid length of the given array: given length is " + dArray.length + ", required length is " + this.size());
        }
        int n = 0;
        for (StatProbe statProbe : this.probes) {
            dArray[n++] = statProbe == null ? Double.NaN : statProbe.average();
        }
    }

    public boolean isCollecting() {
        return this.collect;
    }

    public void setCollecting(boolean bl) {
        this.collect = bl;
    }

    public boolean isBroadcasting() {
        return this.broadcast;
    }

    public void setBroadcasting(boolean bl) {
        this.broadcast = bl;
    }

    public void addArrayOfObservationListener(ArrayOfObservationListener arrayOfObservationListener) {
        if (arrayOfObservationListener == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(arrayOfObservationListener)) {
            this.listeners.add(arrayOfObservationListener);
        }
    }

    public void removeArrayOfObservationListener(ArrayOfObservationListener arrayOfObservationListener) {
        this.listeners.remove(arrayOfObservationListener);
    }

    public void clearArrayOfObservationListeners() {
        this.listeners.clear();
    }

    public void notifyListeners(double[] dArray) {
        if (!this.broadcast) {
            return;
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            this.listeners.get(i).newArrayOfObservations(this, dArray);
        }
    }

    public String report() {
        return StatProbe.report(this.name, this);
    }

    public ListOfStatProbes<E> clone() {
        ListOfStatProbes listOfStatProbes;
        try {
            listOfStatProbes = (ListOfStatProbes)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("CloneNotSupportedException for a class implementing Cloneable");
        }
        if (this.probes != null) {
            listOfStatProbes.probes = new ArrayList<E>(this.probes);
        }
        return listOfStatProbes;
    }

    @Override
    public boolean add(E e) {
        return this.probes.add(e);
    }

    @Override
    public void add(int n, E e) {
        this.probes.add(n, e);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.probes.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        return this.probes.addAll(n, collection);
    }

    @Override
    public void clear() {
        this.probes.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.probes.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.probes.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.probes).equals(object);
    }

    @Override
    public E get(int n) {
        return (E)((StatProbe)this.probes.get(n));
    }

    @Override
    public int hashCode() {
        return ((Object)this.probes).hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.probes.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.probes.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.probes.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.probes.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.probes.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return this.probes.listIterator();
    }

    @Override
    public E remove(int n) {
        return (E)((StatProbe)this.probes.remove(n));
    }

    @Override
    public boolean remove(Object object) {
        return this.probes.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.probes.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.probes.retainAll(collection);
    }

    @Override
    public E set(int n, E e) {
        return (E)((StatProbe)this.probes.set(n, e));
    }

    @Override
    public int size() {
        return this.probes.size();
    }

    @Override
    public List<E> subList(int n, int n2) {
        return this.probes.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.probes.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.probes.toArray(TArray);
    }
}

