/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents.eventlist;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.util.PrintfFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Henriksen
implements EventList {
    private static final double MIN_VALUE = -1.0E39;
    private static final double MAX_VALUE = 1.0E39;
    private static final int ARRAY_LENGTH_INIT = 256;
    private int modCount = 0;
    private Entry firstEntry;
    private Entry[] entryVec;
    private int vectSize;
    private int arrayLength;

    public Henriksen() {
        Entry entry = new Entry(null, null, null, 1.0E39);
        entry.left = this.firstEntry = new Entry(null, null, entry, -1.0E39);
        this.arrayLength = 256;
        this.entryVec = new Entry[this.arrayLength];
        this.changeSize(1);
        this.entryVec[0] = entry;
    }

    @Override
    public boolean isEmpty() {
        return this.firstEntry.right == this.entryVec[0];
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.firstEntry.right = this.entryVec[0];
        this.entryVec[0].left = this.firstEntry;
        this.changeSize(1);
        for (int i = 1; i < this.arrayLength; ++i) {
            this.entryVec[i] = null;
        }
        ++this.modCount;
    }

    @Override
    public void add(Event event) {
        Entry entry;
        Entry entry2 = this.findEntry(event, false);
        entry.right.left = entry = new Entry(event, entry2, entry2.right, event.time());
        entry2.right = entry;
        ++this.modCount;
    }

    @Override
    public void addFirst(Event event) {
        Entry entry;
        this.firstEntry.right.left = entry = new Entry(event, this.firstEntry, this.firstEntry.right, event.time());
        this.firstEntry.right = entry;
        ++this.modCount;
    }

    @Override
    public void addBefore(Event event, Event event2) {
        Entry entry;
        Entry entry2 = this.findEntry(event2, true);
        if (entry2 == null) {
            throw new IllegalArgumentException("Event not in list.");
        }
        entry2.left.right = entry = new Entry(event, entry2.left, entry2, event.time());
        entry2.left = entry;
        ++this.modCount;
    }

    @Override
    public void addAfter(Event event, Event event2) {
        Entry entry;
        Entry entry2 = this.findEntry(event2, true);
        if (entry2 == null) {
            throw new IllegalArgumentException("Event not in list.");
        }
        entry2.left.right = entry = new Entry(event, entry2, entry2.right, event.time());
        entry2.left = entry;
        ++this.modCount;
    }

    @Override
    public Event getFirst() {
        return this.firstEntry.right.event;
    }

    @Override
    public Event getFirstOfClass(String string) {
        Entry entry = this.firstEntry.right;
        while (entry.right != null) {
            if (entry.event.getClass().getName().equals(string)) {
                return entry.event;
            }
            entry = entry.right;
        }
        return null;
    }

    @Override
    public <E extends Event> E getFirstOfClass(Class<E> clazz) {
        Entry entry = this.firstEntry.right;
        while (entry.right != null) {
            if (entry.event.getClass() == clazz) {
                return (E)entry.event;
            }
            entry = entry.right;
        }
        return null;
    }

    @Override
    public Iterator<Event> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Event> listIterator() {
        return new HItr();
    }

    @Override
    public boolean remove(Event event) {
        Entry entry = this.findEntry(event, true);
        if (entry == null) {
            return false;
        }
        double d = event.time();
        int n = this.findIndex(d);
        ++n;
        while (n < this.vectSize && this.entryVec[n].time == d) {
            if (this.entryVec[n].event == event) {
                this.entryVec[n] = entry.left;
            }
            ++n;
        }
        entry.left.right = entry.right;
        entry.right.left = entry.left;
        entry.right = null;
        entry.left = null;
        entry.event = null;
        ++this.modCount;
        return true;
    }

    @Override
    public Event removeFirst() {
        Entry entry;
        if (this.entryVec[this.vectSize / 2].time <= this.firstEntry.right.time && this.vectSize > 2) {
            this.changeSize(this.vectSize / 2);
        }
        if ((entry = this.firstEntry.right) == this.entryVec[0]) {
            return null;
        }
        this.firstEntry.right = entry.right;
        entry.right.left = this.firstEntry;
        entry.right = null;
        entry.left = null;
        Event event = entry.event;
        entry.event = null;
        ++this.modCount;
        return event;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Contents of the event list Henriksen :");
        Entry entry = this.firstEntry.right;
        while (entry.right != null) {
            stringBuffer.append("\n" + PrintfFormat.g(8, 4, entry.event.time()) + " : " + entry.event.toString());
            entry = entry.right;
        }
        return stringBuffer.toString();
    }

    private void changeSize(int n) {
        if (n > this.arrayLength) {
            Entry[] entryArray = new Entry[n];
            for (int i = 0; i < this.vectSize; ++i) {
                entryArray[i] = this.entryVec[i];
            }
            this.entryVec = entryArray;
            this.arrayLength = n;
        }
        for (int i = this.vectSize; i < n; ++i) {
            this.entryVec[i] = this.firstEntry;
        }
        this.vectSize = n;
    }

    private int findIndex(double d) {
        int n = this.vectSize / 2;
        for (int i = this.vectSize / 4; i > 0; i /= 2) {
            if (d >= this.entryVec[n].time) {
                n -= i;
                continue;
            }
            n += i;
        }
        if (d >= this.entryVec[n].time) {
            --n;
        }
        return n;
    }

    private Entry findEntry(Event event, boolean bl) {
        double d = event.time();
        int n = this.findIndex(d);
        Entry entry = this.entryVec[n].left;
        int n2 = 0;
        while (entry.time > d) {
            if (++n2 == 4) {
                if (n + 1 >= this.vectSize) {
                    this.changeSize(this.vectSize * 2);
                }
                n2 = 0;
                this.entryVec[++n] = entry;
            }
            entry = entry.left;
        }
        if (bl) {
            Entry entry2 = entry;
            while (entry != this.firstEntry && entry.time == d && entry.event != event) {
                entry = entry.left;
            }
            if (entry.event != event) {
                return null;
            }
        }
        return entry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HItr
    implements ListIterator<Event> {
        private Entry prev;
        private Entry next;
        private Entry lastRet;
        private int expectedModCount;
        private int nextIndex;

        private HItr() {
            this.prev = Henriksen.this.firstEntry;
            this.next = ((Henriksen)Henriksen.this).firstEntry.right;
            this.expectedModCount = Henriksen.this.modCount;
            this.lastRet = null;
            this.nextIndex = 0;
        }

        @Override
        public void add(Event event) {
            Entry entry;
            if (Henriksen.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (event.time() > this.next.time) {
                event.setTime(this.next.time);
            }
            if (event.time() < this.prev.time) {
                event.setTime(this.prev.time);
            }
            this.prev.right = entry = new Entry(event, this.prev, this.next, event.time());
            this.next.left = entry;
            this.prev = entry;
            ++this.nextIndex;
            this.lastRet = null;
            Henriksen.this.modCount++;
            ++this.expectedModCount;
        }

        @Override
        public boolean hasNext() {
            if (Henriksen.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != Henriksen.this.entryVec[0];
        }

        @Override
        public boolean hasPrevious() {
            if (Henriksen.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != Henriksen.this.firstEntry;
        }

        @Override
        public Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Event event = this.next.event;
            this.lastRet = this.next;
            this.next = this.next.right;
            this.prev = this.prev.right;
            return event;
        }

        @Override
        public int nextIndex() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex;
        }

        @Override
        public Event previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            Event event = this.prev.event;
            this.lastRet = this.prev;
            this.prev = this.prev.left;
            this.next = this.next.left;
            return event;
        }

        @Override
        public int previousIndex() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            if (Henriksen.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet == this.next) {
                if (this.next != Henriksen.this.entryVec[0]) {
                    this.next = this.next.right;
                }
            } else if (this.prev != Henriksen.this.firstEntry) {
                this.prev = this.prev.left;
                --this.nextIndex;
            }
            double d = this.lastRet.time;
            int n = Henriksen.this.findIndex(d);
            ++n;
            while (n < Henriksen.this.vectSize && ((Henriksen)Henriksen.this).entryVec[n].time == d) {
                if (((Henriksen)Henriksen.this).entryVec[n].event == this.lastRet.event) {
                    ((Henriksen)Henriksen.this).entryVec[n] = this.lastRet.left;
                }
                ++n;
            }
            this.lastRet.event = null;
            this.lastRet.left.right = this.lastRet.right;
            this.lastRet.right.left = this.lastRet.left;
            this.lastRet.left = null;
            this.lastRet.right = null;
            this.lastRet = null;
            Henriksen.this.modCount++;
            ++this.expectedModCount;
        }

        @Override
        public void set(Event event) {
            if (Henriksen.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (event.time() < this.lastRet.left.time) {
                event.setTime(this.lastRet.left.time);
            }
            if (event.time() > this.lastRet.right.time) {
                event.setTime(this.lastRet.right.time);
            }
            this.lastRet.event = event;
        }
    }

    private static class Entry {
        public Event event;
        public Entry left;
        public Entry right;
        public double time;

        Entry(Event event, Entry entry, Entry entry2, double d) {
            this.event = event;
            this.left = entry;
            this.right = entry2;
            this.time = d;
        }

        public String toString() {
            return "[" + this.event + " |" + this.time + "|]";
        }
    }
}

