/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import java.util.Random;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.rng.WELL607;
import umontreal.iro.lecuyer.rng.WELL607base;

public class F2NL607
extends WELL607base {
    private static final long serialVersionUID = 70510L;
    private static int[] curr_stream;
    private static int[][] nlData;
    private static int[] nlJumpW;
    private static int[] nlJumpZ;
    private int[] nlState;
    private int[] nlStream;
    private int[] nlSubstream;
    private static int[] curr_nlStream;
    private static boolean constructed;

    private static void scramble(int[] nArray, Random random) {
        for (int i = 0; i < nArray.length - 1; ++i) {
            int n = (int)(random.nextDouble() * (double)(nArray.length - i)) + i;
            int n2 = nArray[i];
            nArray[i] = nArray[n];
            nArray[n] = n2;
        }
    }

    private static void scramble(int[] nArray, RandomStream randomStream) {
        for (int i = 0; i < nArray.length - 1; ++i) {
            int n = randomStream.nextInt(i, nArray.length - 1);
            int n2 = nArray[i];
            nArray[i] = nArray[n];
            nArray[n] = n2;
        }
    }

    public F2NL607() {
        int n;
        F2NL607.initialisation();
        constructed = true;
        this.state = new int[32];
        this.stream = new int[19];
        this.substream = new int[19];
        for (n = 0; n < 19; ++n) {
            this.stream[n] = curr_stream[n];
        }
        this.advanceSeed(curr_stream, WELL607.pz);
        this.nlState = new int[nlData.length];
        this.nlStream = new int[nlData.length];
        this.nlSubstream = new int[nlData.length];
        for (n = 0; n < nlData.length; ++n) {
            this.nlStream[n] = curr_nlStream[n];
            int n2 = n;
            curr_nlStream[n2] = curr_nlStream[n2] + nlJumpZ[n];
        }
        this.resetStartStream();
    }

    public F2NL607(String string) {
        this();
        this.name = string;
    }

    public void resetStartStream() {
        int n;
        for (n = 0; n < 19; ++n) {
            this.substream[n] = this.stream[n];
        }
        for (n = 0; n < this.nlSubstream.length; ++n) {
            this.nlSubstream[n] = this.nlStream[n];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        int n;
        this.state_i = 0;
        for (n = 0; n < 19; ++n) {
            this.state[n] = this.substream[n];
        }
        for (n = 0; n < this.nlState.length; ++n) {
            this.nlState[n] = this.nlSubstream[n];
        }
    }

    public void resetNextSubstream() {
        this.advanceSeed(this.substream, WELL607.pw);
        for (int i = 0; i < this.nlState.length; ++i) {
            this.nlSubstream[i] = (this.nlSubstream[i] + nlJumpW[i]) % nlData[i].length;
        }
        this.resetStartSubstream();
    }

    public static void setPackageLinearSeed(int[] nArray) {
        F2NL607.verifySeed(nArray);
        for (int i = 0; i < 19; ++i) {
            F2NL607.curr_stream[i] = nArray[i];
        }
    }

    public void setLinearSeed(int[] nArray) {
        F2NL607.verifySeed(nArray);
        for (int i = 0; i < 19; ++i) {
            this.stream[i] = nArray[i];
        }
        this.resetStartStream();
    }

    public int[] getLinearState() {
        return this.getState();
    }

    public static void setPackageNonLinearSeed(int[] nArray) {
        int n;
        if (nArray.length != nlData.length) {
            throw new IllegalArgumentException("Seed must contain " + nlData.length + " values");
        }
        for (n = 0; n < nlData.length; ++n) {
            if (nArray[n] >= 0 && nArray[n] < nlData[n].length) continue;
            throw new IllegalArgumentException("Seed number " + n + " must be between 0 and " + (nlData[n].length - 1));
        }
        for (n = 0; n < nlData.length; ++n) {
            F2NL607.curr_nlStream[n] = nArray[n];
        }
    }

    public void setNonLinearSeed(int[] nArray) {
        int n;
        if (nArray.length != nlData.length) {
            throw new IllegalArgumentException("Seed must contain " + nlData.length + " values");
        }
        for (n = 0; n < nlData.length; ++n) {
            if (nArray[n] >= 0 && nArray[n] < nlData[n].length) continue;
            throw new IllegalArgumentException("Seed number " + n + " must be between 0 and " + (nlData[n].length - 1));
        }
        for (n = 0; n < nlData.length; ++n) {
            this.nlStream[n] = nArray[n];
        }
        this.resetStartStream();
    }

    public int[] getNonLinearState() {
        int[] nArray = new int[this.nlState.length];
        for (int i = 0; i < this.nlState.length; ++i) {
            nArray[i] = this.nlState[i];
        }
        return nArray;
    }

    public static int[][] getNonLinearData() {
        int[][] nArrayArray = new int[nlData.length][];
        for (int i = 0; i < nlData.length; ++i) {
            nArrayArray[i] = new int[nlData[i].length];
            for (int j = 0; j < nlData[i].length; ++j) {
                nArrayArray[i][j] = nlData[i][j];
            }
        }
        return nArrayArray;
    }

    public static void setNonLinearData(int[][] nArray) {
        int n;
        int n2;
        if (constructed) {
            throw new IllegalStateException("setNonLinearData can only be called before the creation of any F2NL607");
        }
        nlData = new int[nArray.length][];
        curr_nlStream = new int[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            F2NL607.nlData[n2] = new int[nArray[n2].length];
            for (n = 0; n < nArray[n2].length; ++n) {
                F2NL607.nlData[n2][n] = nArray[n2][n];
            }
            F2NL607.curr_nlStream[n2] = 0;
        }
        nlJumpW = new int[nArray.length];
        nlJumpZ = new int[nArray.length];
        for (n2 = 0; n2 < nlJumpW.length; ++n2) {
            int n3;
            n = 1;
            for (n3 = 0; n3 < 250; ++n3) {
                n = 2 * n % nlData[n2].length;
            }
            F2NL607.nlJumpW[n2] = n;
            for (n3 = 0; n3 < 150; ++n3) {
                n = 2 * n % nlData[n2].length;
            }
            F2NL607.nlJumpZ[n2] = n;
        }
    }

    public static void setScrambleData(RandomStream randomStream, int n, int[] nArray) {
        int n2;
        int n3;
        if (constructed) {
            throw new IllegalStateException("setScrambleData can only be called before the creation of any F2NL607");
        }
        curr_nlStream = new int[nArray.length];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            F2NL607.curr_nlStream[n3] = 0;
        }
        nlData = new int[nArray.length][];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            F2NL607.nlData[n3] = new int[nArray[n3]];
        }
        for (n3 = 0; n3 < nlData.length; ++n3) {
            for (n2 = 0; n2 < nlData[n3].length; ++n2) {
                F2NL607.nlData[n3][n2] = (int)(((long)n2 << 32) / (long)nlData[n3].length);
            }
            for (n2 = 0; n2 < n; ++n2) {
                F2NL607.scramble(nlData[n3], randomStream);
            }
        }
        nlJumpW = new int[nArray.length];
        nlJumpZ = new int[nArray.length];
        for (n3 = 0; n3 < nlJumpW.length; ++n3) {
            int n4;
            n2 = 1;
            for (n4 = 0; n4 < 250; ++n4) {
                n2 = 2 * n2 % nlData[n3].length;
            }
            F2NL607.nlJumpW[n3] = n2;
            for (n4 = 0; n4 < 150; ++n4) {
                n2 = 2 * n2 % nlData[n3].length;
            }
            F2NL607.nlJumpZ[n3] = n2;
        }
    }

    public F2NL607 clone() {
        int n;
        F2NL607 f2NL607 = null;
        f2NL607 = (F2NL607)super.clone();
        f2NL607.state = new int[32];
        f2NL607.substream = new int[19];
        f2NL607.stream = new int[19];
        f2NL607.nlState = new int[nlData.length];
        f2NL607.nlStream = new int[nlData.length];
        f2NL607.nlSubstream = new int[nlData.length];
        for (n = 0; n < 19; ++n) {
            f2NL607.substream[n] = this.substream[n];
            f2NL607.stream[n] = this.stream[n];
        }
        for (n = 0; n < 32; ++n) {
            f2NL607.state[n] = this.state[n];
        }
        for (n = 0; n < nlData.length; ++n) {
            f2NL607.nlState[n] = this.nlState[n];
            f2NL607.nlStream[n] = this.nlStream[n];
            f2NL607.nlSubstream[n] = this.nlSubstream[n];
        }
        return f2NL607;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.name == null) {
            stringBuffer.append("The state of this F2NL607 is : \n");
        } else {
            stringBuffer.append("The state of " + this.name + " is : \n");
        }
        stringBuffer.append(" Linear part : { ");
        stringBuffer.append(super.stringState());
        stringBuffer.append("\n Non-linear part : { ");
        for (int i = 0; i < this.nlState.length; ++i) {
            stringBuffer.append(this.nlState[i] + " ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    protected double nextValue() {
        int n;
        for (n = 0; n < nlData.length; ++n) {
            if (this.nlState[n] >= nlData[n].length - 1) {
                this.nlState[n] = 0;
                continue;
            }
            int n2 = n;
            this.nlState[n2] = this.nlState[n2] + 1;
        }
        n = 0;
        for (int i = 0; i < nlData.length; ++i) {
            n += nlData[i][this.nlState[i]];
        }
        long l = this.nextInt() ^ n;
        if (l <= 0L) {
            l += 0x100000000L;
        }
        return (double)l * 2.3283064359965952E-10;
    }

    static {
        int n;
        int n2;
        curr_stream = new int[]{-693127396, -2102546034, 846098766, -1309785418, -240634643, 78534433, -974510013, -100396693, 1791890671, -849903200, 1797223196, 2117832253, -1959469526, 1961629173, -2064924138, -2081805215, -458736866, -1512559431, -1642435447};
        constructed = false;
        curr_nlStream = new int[]{0, 0, 0};
        nlData = new int[][]{new int[1019], new int[1021], new int[1031]};
        Random random = new Random(0L);
        for (n2 = 0; n2 < nlData.length; ++n2) {
            for (n = 0; n < nlData[n2].length; ++n) {
                F2NL607.nlData[n2][n] = (int)(((long)n << 32) / (long)nlData[n2].length);
            }
            F2NL607.scramble(nlData[n2], random);
        }
        nlJumpW = new int[3];
        nlJumpZ = new int[3];
        for (n2 = 0; n2 < nlJumpW.length; ++n2) {
            int n3;
            n = 1;
            for (n3 = 0; n3 < 250; ++n3) {
                n = 2 * n % nlData[n2].length;
            }
            F2NL607.nlJumpW[n2] = n;
            for (n3 = 0; n3 < 150; ++n3) {
                n = 2 * n % nlData[n2].length;
            }
            F2NL607.nlJumpZ[n2] = n;
        }
    }
}

