/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvarmulti;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.randvarmulti.RandomMultivariateGen;

public class MultinormalCholeskyGen
extends RandomMultivariateGen {
    private double[] mu;
    private DoubleMatrix2D sigma;
    private DoubleMatrix2D sqrtSigma;
    private double[] temp;

    public MultinormalCholeskyGen(NormalGen normalGen, int n) {
        if (normalGen == null) {
            throw new NullPointerException("gen1 is null");
        }
        NormalDist normalDist = (NormalDist)normalGen.getDistribution();
        if (normalDist.getMu() != 0.0) {
            throw new IllegalArgumentException("mu != 0");
        }
        if (normalDist.getSigma() != 1.0) {
            throw new IllegalArgumentException("sigma != 1");
        }
        this.gen1 = normalGen;
        this.stream = normalGen.getStream();
        normalDist = null;
        this.dimension = n;
        this.mu = new double[n];
        this.sigma = new DenseDoubleMatrix2D(n, n);
        this.sqrtSigma = new DenseDoubleMatrix2D(n, n);
        this.temp = new double[n];
        for (int i = 0; i < n; ++i) {
            this.sigma.setQuick(i, i, 1.0);
            this.sqrtSigma.setQuick(i, i, 1.0);
        }
    }

    public MultinormalCholeskyGen(NormalGen normalGen, double[] dArray, DoubleMatrix2D doubleMatrix2D) {
        if (normalGen == null) {
            throw new NullPointerException("gen1 is null");
        }
        NormalDist normalDist = (NormalDist)normalGen.getDistribution();
        if (normalDist.getMu() != 0.0) {
            throw new IllegalArgumentException("mu != 0");
        }
        if (normalDist.getSigma() != 1.0) {
            throw new IllegalArgumentException("sigma != 1");
        }
        this.gen1 = normalGen;
        this.stream = normalGen.getStream();
        normalDist = null;
        this.dimension = dArray.length;
        this.mu = (double[])dArray.clone();
        this.sigma = doubleMatrix2D.copy();
        this.initL();
    }

    public MultinormalCholeskyGen(NormalGen normalGen, double[] dArray, double[][] dArray2) {
        if (normalGen == null) {
            throw new NullPointerException("gen1 is null");
        }
        NormalDist normalDist = (NormalDist)normalGen.getDistribution();
        if (normalDist.getMu() != 0.0) {
            throw new IllegalArgumentException("mu != 0");
        }
        if (normalDist.getSigma() != 1.0) {
            throw new IllegalArgumentException("sigma != 1");
        }
        this.gen1 = normalGen;
        this.stream = normalGen.getStream();
        normalDist = null;
        this.dimension = dArray.length;
        this.mu = (double[])dArray.clone();
        this.sigma = new DenseDoubleMatrix2D(dArray2);
        this.initL();
    }

    private void initL() {
        if (this.mu.length != this.sigma.rows() || this.mu.length != this.sigma.columns()) {
            throw new IllegalArgumentException("Incompatible mean vector and covariance matrix");
        }
        CholeskyDecomposition choleskyDecomposition = new CholeskyDecomposition(this.sigma);
        this.sqrtSigma = choleskyDecomposition.getL();
        this.temp = new double[this.mu.length];
    }

    public double[] getMu() {
        return this.mu;
    }

    public double getMu(int n) {
        return this.mu[n];
    }

    public void setMu(double[] dArray) {
        if (dArray.length != this.mu.length) {
            throw new IllegalArgumentException("Incompatible length of mean vector");
        }
        this.mu = dArray;
    }

    public void setMu(int n, double d) {
        this.mu[n] = d;
    }

    public DoubleMatrix2D getSigma() {
        return this.sigma.copy();
    }

    public DoubleMatrix2D getCholeskyDecompSigma() {
        return this.sqrtSigma.copy();
    }

    public void setSigma(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != this.mu.length || doubleMatrix2D.columns() != this.mu.length) {
            throw new IllegalArgumentException("Invalid dimensions of covariance matrix");
        }
        CholeskyDecomposition choleskyDecomposition = new CholeskyDecomposition(doubleMatrix2D);
        this.sigma.assign(doubleMatrix2D);
        this.sqrtSigma = choleskyDecomposition.getL();
    }

    public static void nextPoint(NormalGen normalGen, double[] dArray, DoubleMatrix2D doubleMatrix2D, double[] dArray2) {
        int n;
        if (normalGen == null) {
            throw new NullPointerException("gen1 is null");
        }
        NormalDist normalDist = (NormalDist)normalGen.getDistribution();
        if (normalDist.getMu() != 0.0) {
            throw new IllegalArgumentException("mu != 0");
        }
        if (normalDist.getSigma() != 1.0) {
            throw new IllegalArgumentException("sigma != 1");
        }
        if (dArray.length != doubleMatrix2D.rows() || dArray.length != doubleMatrix2D.columns()) {
            throw new IllegalArgumentException("Incompatible mean vector and covariance matrix dimensions");
        }
        CholeskyDecomposition choleskyDecomposition = new CholeskyDecomposition(doubleMatrix2D);
        double[] dArray3 = new double[dArray.length];
        DoubleMatrix2D doubleMatrix2D2 = choleskyDecomposition.getL();
        for (n = 0; n < dArray3.length; ++n) {
            dArray3[n] = normalGen.nextDouble();
        }
        for (n = 0; n < dArray3.length; ++n) {
            dArray2[n] = 0.0;
            for (int i = 0; i < dArray3.length; ++i) {
                int n2 = n;
                dArray2[n2] = dArray2[n2] + doubleMatrix2D2.getQuick(n, i) * dArray3[i];
            }
            int n3 = n;
            dArray2[n3] = dArray2[n3] + dArray[n];
        }
    }

    public static void nextPoint(NormalGen normalGen, double[] dArray, double[][] dArray2, double[] dArray3) {
        int n;
        if (normalGen == null) {
            throw new NullPointerException("gen1 is null");
        }
        NormalDist normalDist = (NormalDist)normalGen.getDistribution();
        if (normalDist.getMu() != 0.0) {
            throw new IllegalArgumentException("mu != 0");
        }
        if (normalDist.getSigma() != 1.0) {
            throw new IllegalArgumentException("sigma != 1");
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(dArray2);
        if (dArray.length != denseDoubleMatrix2D.rows() || dArray.length != denseDoubleMatrix2D.columns()) {
            throw new IllegalArgumentException("Incompatible mean vector and covariance matrix dimensions");
        }
        CholeskyDecomposition choleskyDecomposition = new CholeskyDecomposition((DoubleMatrix2D)denseDoubleMatrix2D);
        double[] dArray4 = new double[dArray.length];
        DoubleMatrix2D doubleMatrix2D = choleskyDecomposition.getL();
        for (n = 0; n < dArray4.length; ++n) {
            dArray4[n] = normalGen.nextDouble();
        }
        for (n = 0; n < dArray4.length; ++n) {
            dArray3[n] = 0.0;
            for (int i = 0; i < dArray4.length; ++i) {
                int n2 = n;
                dArray3[n2] = dArray3[n2] + doubleMatrix2D.getQuick(n, i) * dArray4[i];
            }
            int n3 = n;
            dArray3[n3] = dArray3[n3] + dArray[n];
        }
    }

    public void nextPoint(double[] dArray) {
        int n;
        int n2 = this.mu.length;
        for (n = 0; n < n2; ++n) {
            this.temp[n] = this.gen1.nextDouble();
        }
        for (n = 0; n < n2; ++n) {
            dArray[n] = 0.0;
            for (int i = 0; i < n2; ++i) {
                int n3 = n;
                dArray[n3] = dArray[n3] + this.sqrtSigma.getQuick(n, i) * this.temp[i];
            }
            int n4 = n;
            dArray[n4] = dArray[n4] + this.mu[n];
        }
    }
}

