/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Uncmin_f77;
import optimization.Uncmin_methods;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class HyperbolicSecantDist
extends ContinuousDistribution {
    protected double mu;
    protected double sigma;

    public HyperbolicSecantDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        return HyperbolicSecantDist.density(this.mu, this.sigma, d);
    }

    public double cdf(double d) {
        return HyperbolicSecantDist.cdf(this.mu, this.sigma, d);
    }

    public double barF(double d) {
        return HyperbolicSecantDist.barF(this.mu, this.sigma, d);
    }

    public double inverseF(double d) {
        return HyperbolicSecantDist.inverseF(this.mu, this.sigma, d);
    }

    public double getMean() {
        return HyperbolicSecantDist.getMean(this.mu, this.sigma);
    }

    public double getVariance() {
        return HyperbolicSecantDist.getVariance(this.mu, this.sigma);
    }

    public double getStandardDeviation() {
        return HyperbolicSecantDist.getStandardDeviation(this.mu, this.sigma);
    }

    public static double density(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        double d4 = (d3 - d) / d2;
        if (Math.abs(d4) >= 50.0) {
            return 0.0;
        }
        return 1.0 / (Math.cosh(Math.PI * d4 / 2.0) * 2.0 * d2);
    }

    public static double cdf(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        double d4 = (d3 - d) / d2;
        if (d4 >= 50.0) {
            return 1.0;
        }
        if (d4 <= -50.0) {
            return 0.0;
        }
        return 2.0 * Math.atan(Math.exp(Math.PI * d4 / 2.0)) / Math.PI;
    }

    public static double barF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        double d4 = (d3 - d) / d2;
        if (d4 >= 50.0) {
            return 0.0;
        }
        if (d4 <= -50.0) {
            return 1.0;
        }
        return 0.6366197723675814 * Math.atan(1.0 / Math.exp(Math.PI * d4 / 2.0));
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d3 >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d3 <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return d + 2.0 * d2 / Math.PI * Math.log(Math.tan(1.5707963267948966 * d3));
    }

    public static double[] getMLE(double[] dArray, int n) {
        int n2;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        Optim optim = new Optim(dArray, n);
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        int[] nArray = new int[2];
        double[][] dArray7 = new double[3][3];
        double[] dArray8 = new double[3];
        double d = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            d += dArray[n2];
        }
        dArray4[1] = d / (double)n;
        d = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            d += (dArray[n2] - dArray4[1]) * (dArray[n2] - dArray4[1]);
        }
        dArray4[2] = Math.sqrt(d / (double)n);
        Uncmin_f77.optif0_f77((int)2, (double[])dArray4, (Uncmin_methods)optim, (double[])dArray3, (double[])dArray5, (double[])dArray6, (int[])nArray, (double[][])dArray7, (double[])dArray8);
        for (n2 = 0; n2 < 2; ++n2) {
            dArray2[n2] = dArray3[n2 + 1];
        }
        return dArray2;
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        return HyperbolicSecantDist.getMLE(dArray, n);
    }

    public static HyperbolicSecantDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = HyperbolicSecantDist.getMaximumLikelihoodEstimate(dArray, n);
        return new HyperbolicSecantDist(dArray2[0], dArray2[1]);
    }

    public static double getMean(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return d;
    }

    public static double getVariance(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return d2 * d2;
    }

    public static double getStandardDeviation(double d, double d2) {
        return Math.sqrt(HyperbolicSecantDist.getVariance(d, d2));
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setParams(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        this.mu = d;
        this.sigma = d2;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.mu, this.sigma};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : mu = " + this.mu + ", sigma = " + this.sigma;
    }

    private static class Optim
    implements Uncmin_methods {
        private int n;
        private double[] xi;

        public Optim(double[] dArray, int n) {
            this.n = n;
            this.xi = new double[n];
            System.arraycopy(dArray, 0, this.xi, 0, n);
        }

        public double f_to_minimize(double[] dArray) {
            double d = 0.0;
            if (dArray[2] <= 0.0) {
                return 1.0E200;
            }
            for (int i = 0; i < this.n; ++i) {
                d -= Math.log(HyperbolicSecantDist.density(dArray[1], dArray[2], this.xi[i]));
            }
            return d;
        }

        public void gradient(double[] dArray, double[] dArray2) {
        }

        public void hessian(double[] dArray, double[][] dArray2) {
        }
    }
}

