/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import umontreal.iro.lecuyer.hups.DigitalSequenceBase2;

public class NiedSequenceBase2
extends DigitalSequenceBase2 {
    private static final int MAXDIM = 318;
    private static final int NUMCOLS = 30;
    private static int[] NiedMat = new int[9540];
    private static final int MAXN = 9540;

    public NiedSequenceBase2(int n, int n2, int n3) {
        this.init(n, n2, n2, n3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Niederreiter sequence:\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    private void init(int n, int n2, int n3, int n4) {
        if (n4 < 1 || n4 > 318) {
            throw new IllegalArgumentException("Dimension for NiedSequenceBase2 must be > 1 and <= 318");
        }
        if (n2 < n || n3 < n2 || n3 > 31 || n >= 31) {
            throw new IllegalArgumentException("One must have k < 31 and k <= r <= w <= 31 for NiedSequenceBase2");
        }
        this.numCols = n;
        this.numRows = n2;
        this.outDigits = n3;
        this.numPoints = 1 << n;
        this.dim = n4;
        this.normFactor = 1.0 / (double)(1L << this.outDigits);
        this.genMat = new int[n4 * this.numCols];
        this.initGenMat();
    }

    public void extendSequence(int n) {
        this.init(n, this.numRows, this.outDigits, this.dim);
    }

    private void initGenMat() {
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.genMat[i * this.numCols + j] = NiedMat[i * 30 + j] << 1;
                int n = i * this.numCols + j;
                this.genMat[n] = this.genMat[n] >> 31 - this.outDigits;
            }
        }
    }

    static {
        try {
            InputStream inputStream = NiedSequenceBase2.class.getClassLoader().getResourceAsStream("umontreal/iro/lecuyer/hups/dataSer/Nieder/NiedSequenceBase2.ser");
            if (inputStream == null) {
                throw new FileNotFoundException("Cannot find NiedSequenceBase2.ser");
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            NiedMat = (int[])objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.exit(1);
        }
    }
}

