% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_checkboxes.R
\name{combine_and_repair_tbls}
\alias{combine_and_repair_tbls}
\title{Combine checkbox fields with respect to repaired outputs}
\usage{
combine_and_repair_tbls(data_tbl, data_tbl_mod, new_cols, names_repair)
}
\arguments{
\item{data_tbl}{The original data table given to \code{\link[=combine_checkboxes]{combine_checkboxes()}}}

\item{data_tbl_mod}{A modified data table from \code{data_tbl}}

\item{new_cols}{The new columns created for checkbox combination}

\item{names_repair}{What happens if the output has invalid column names?
The default, "check_unique" is to error if the columns are duplicated.
Use "minimal" to allow duplicates in the output, or "unique" to de-duplicated
by adding numeric suffixes. See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for more options.}
}
\value{
a tibble
}
\description{
This function seeks to preserve the original data columns and types from the
originally supplied data_tbl and add on the new columns from data_tbl_mod.

If \code{names_repair} presents a repair strategy, the output columns will be
captured and updated here while dropping the original columns.
}
\keyword{internal}
