% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_table.R
\name{extract_table}
\alias{extract_table}
\title{Extract a single tibble from a REDCapTidieR supertibble}
\usage{
extract_table(.data, tbl)
}
\arguments{
\item{.data}{A tibble generated by \code{read_redcap_tidy()}. Required.}

\item{tbl}{The \code{form_name} to extract. Required.}
}
\value{
A \code{tibble}
}
\description{
Take a supertibble generated with \code{read_redcap_tidy()}
and return one of its tibbles.
}
\details{
This function makes it easy to extract a single instrument's data from a
REDCapTidieR supertibble.
}
\examples{
# Supply a `read_redcap_tidy()` output to for table extraction
sample_data <- tibble::tribble(
  ~redcap_form_name,    ~redcap_data,   ~structure,
  "super_hero_powers",   list(),         "repeating",
  "heroes_information",  list(),         "nonrepeating"
)


extract_table(sample_data, "heroes_information")

}
