% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-arm-export.R
\name{redcap_arm_export}
\alias{redcap_arm_export}
\title{Export Arms}
\usage{
redcap_arm_export(redcap_uri, token, verbose = TRUE, config_options = NULL)
}
\arguments{
\item{redcap_uri}{The URI (uniform resource identifier) of the REDCap
project.  Required.}

\item{token}{The user-specific string that serves as the password for a
project.  Required.}

\item{verbose}{A boolean value indicating if \code{message}s should be printed
to the R console during the operation.  The verbose output might contain
sensitive information (\emph{e.g.} PHI), so turn this off if the output might
be visible somewhere public. Optional.}

\item{config_options}{A list of options to pass to \code{POST} method in the
\code{httr} package.  See the details in \code{\link[=redcap_read_oneshot]{redcap_read_oneshot()}}. Optional.}
}
\value{
Currently, a list is returned with the following elements:
\itemize{
\item \code{has_arms}: a \code{logical} value indicating if the REDCap project has
arms (\emph{i.e.}, "TRUE") or is a classic non-longitudinal project
(\emph{i.e.}, "FALSE").
\item \code{data}: a \code{\link{tibble}} with one row per arm.  The columns are
\code{arm_number} (an integer) and \code{arm_name} (a human-friendly string).
\item \code{success}: A boolean value indicating if the operation was apparently
successful.
\item \code{status_code}: The
\href{https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}{http status code}
of the operation.
\item \code{outcome_message}: A human readable string indicating the operation's
outcome.
\item \code{elapsed_seconds}: The duration of the function.
\item \code{raw_text}: If an operation is NOT successful, the text returned by
REDCap.  If an operation is successful, the \code{raw_text} is returned as an
empty string to save RAM.
}
}
\description{
Export Arms of a REDCap project
}
\examples{
\dontrun{
uri            <- "https://bbmc.ouhsc.edu/redcap/api/"

# Query a classic project with 3 arms
token_1  <- "CDF9F3767E413FDBAA31D92E9F36730A"
result_1 <- REDCapR::redcap_arm_export(redcap_uri=uri, token=token_1)
result_1$has_arms
result_1$data

# Query a classic project without arms
token_2  <- "D70F9ACD1EDD6F151C6EA78683944E98"
result_2 <- REDCapR::redcap_arm_export(redcap_uri=uri, token=token_2)
result_2$has_arms
result_2$data
}
}
\references{
The official documentation can be found on the 'API Help Page'
and 'API Examples' pages on the REDCap wiki (\emph{i.e.},
https://community.projectredcap.org/articles/456/api-documentation.html and
https://community.projectredcap.org/articles/462/api-examples.html).
If you do not have an account for the wiki, please ask your campus REDCap
administrator to send you the static material.
}
\author{
Will Beasley
}
