% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-survey-link-export-oneshot.R
\name{redcap_survey_link_export_oneshot}
\alias{redcap_survey_link_export_oneshot}
\title{Download a file from a REDCap project record}
\usage{
redcap_survey_link_export_oneshot(
  redcap_uri,
  token,
  record,
  instrument,
  event = "",
  verbose = TRUE,
  config_options = NULL
)
}
\arguments{
\item{redcap_uri}{The URI (uniform resource identifier) of the REDCap
project.  Required.}

\item{token}{The user-specific string that serves as the password for a
project.  Required.}

\item{record}{The record ID where the file is to be imported. Required}

\item{instrument}{The name of the instrument associated with the
survey link.  Required}

\item{event}{The name of the event where the file is saved in REDCap.
Optional}

\item{verbose}{A boolean value indicating if \code{message}s should be printed
to the R console during the operation.  Optional.}

\item{config_options}{A list of options to pass to \code{\link[httr:POST]{httr::POST()}} method
in the 'httr' package.  See the details below. Optional.}
}
\value{
Currently, a list is returned with the following elements,
\itemize{
\item \code{success}: A boolean value indicating if the operation was apparently
successful.
\item \code{status_code}: The
\href{http://en.wikipedia.org/wiki/List_of_HTTP_status_codes}{http status code}
of the operation.
\item \code{outcome_message}: A human readable string indicating the operation's
outcome.
\item \code{records_affected_count}: The number of records inserted or updated.
\item \code{affected_ids}: The subject IDs of the inserted or updated records.
\item \code{elapsed_seconds}: The duration of the function.
\item \code{raw_text}: If an operation is NOT successful, the text returned by
REDCap.  If an operation is successful, the \code{raw_text} is returned as an
empty string to save RAM.
\item \code{file_name}: The name of the file persisted to disk. This is useful if
the name stored in REDCap is used (which is the default).
}
}
\description{
This function uses REDCap's API to download a file.
}
\details{
Currently, the function doesn't modify any variable types to conform to
REDCap's supported variables.  See \code{\link[=validate_for_write]{validate_for_write()}} for a helper
function that checks for some common important conflicts.

\strong{Permissions Required}
To use this method, you must have API Export privileges in the project.
(As stated in the 9.0.0 documentation.)
}
\examples{
\dontrun{
uri     <- "https://bbmc.ouhsc.edu/redcap/api/"
token   <- "8FA9A6BDAE2C0B5DD3CB472DD8E8918C" #pid=817
record  <- 1
instrument   <- "participant_morale_questionnaire"
# event <- "" # only for longitudinal projects

result <- REDCapR::redcap_survey_link_export_oneshot(
  record         = record,
  instrument     = instrument,
  redcap_uri     = uri,
  token          = token
)
result$survey_link
}
}
\references{
The official documentation can be found on the 'API Help Page'
and 'API Examples' pages on the REDCap wiki (\emph{i.e.},
https://community.projectredcap.org/articles/456/api-documentation.html and
https://community.projectredcap.org/articles/462/api-examples.html).
If you do not have an account for the wiki, please ask your campus REDCap
administrator to send you the static material.
}
\author{
Will Beasley
}
