% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WGVmix.R
\name{WGVmix}
\alias{WGVmix}
\title{WGVmix: Weighted Generalized Maximum Likelihood for Empirical Bayes
Estimation of Gamma Variances}
\usage{
WGVmix(
  y,
  id,
  w,
  v,
  pv = 300,
  eps = 1e-06,
  rtol = 1e-06,
  verb = 0,
  control = NULL
)
}
\arguments{
\item{y}{A vector of observations}

\item{id}{A strata indicator vector of the same length}

\item{w}{A vector of weights}

\item{v}{A vector of bin boundaries for the variance effects}

\item{pv}{The number of variance effect bins, if u is missing}

\item{eps}{A tolerance for determining the support of the bins}

\item{rtol}{A tolerance for determining duality gap convergence tolerance in
Mosek}

\item{verb}{A flag indicating how verbose the Mosek output should be}

\item{control}{Mosek control list see KWDual documentation}
}
\value{
An object of class \code{density} consisting of the following
components: \item{x}{the variance bin boundaries} \item{y}{the function
values of the mixing density for the variances. } \item{logLik}{the value of
the log likelihood at the solution} \item{status}{the mosek convergence
status.}
}
\description{
A Kiefer-Wolfowitz procedure for ML estimation of a Gaussian model with
independent variance components with weighted longitudinal data.
}
\details{
See Gu and Koenker (2012?)
}
\references{
Gu Y. and R. Koenker (2017) Empirical Bayesball Remixed:  Empirical
Bayes Methods for Longitudinal Data, \emph{J. of Applied Econometrics}, 32, 575-599.

Koenker, R. and J. Gu, (2017) REBayes: An {R} Package for Empirical Bayes Mixture Methods,
\emph{Journal of Statistical Software}, 82, 1--26.
}
\author{
R. Koenker
}
\keyword{nonparametric}
