% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conicThrough5Points.R
\name{conicThrough5Points}
\alias{conicThrough5Points}
\title{Compute the conic that passes through 5 points}
\source{
Richter-Gebert, Jürgen (2011). 
\emph{Perspectives on Projective Geometry - A Guided Tour Through Real
and Complex Geometry}, Springer, Berlin, ISBN: 978-3-642-17285-4
}
\usage{
conicThrough5Points(p1, p2, p3, p4, p5)
}
\arguments{
\item{p1}{\eqn{(3 \times 1)} vectors of the homogeneous coordinates of one of the five points.}

\item{p2}{\eqn{(3 \times 1)} vectors of the homogeneous coordinates of one of the five points.}

\item{p3}{\eqn{(3 \times 1)} vectors of the homogeneous coordinates of one of the five points.}

\item{p4}{\eqn{(3 \times 1)} vectors of the homogeneous coordinates of one of the five points.}

\item{p5}{\eqn{(3 \times 1)} vectors of the homogeneous coordinates of one of the five points.}
}
\value{
A \eqn{(3 \times 3)} matrix representation of the conic passing through the 5 points.
}
\description{
Return the matrix representation of the conic that passes through exactly 5 points.
}
\examples{
# five points
p1 <- c(-4.13, 6.24, 1)
p2 <- c(-8.36, 1.17, 1)
p3 <- c(-2.03, -4.61, 1)
p4 <- c(9.70, -3.49, 1)
p5 <- c(8.02, 3.34, 1)

# matrix representation of the conic passing
# through the five points
C5 <- conicThrough5Points(p1,p2,p3,p4,p5)

# plot
plot(rbind(p1,p2,p3,p4,p5),xlim=c(-10,10), ylim=c(-10,10), asp=1) 
# from matrix to ellipse parameters
E5 <- conicMatrixToEllipse(C5)
lines(ellipse(E5$saxes, E5$loc, E5$theta, n=500))
}
