% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delaunay.R
\name{delaunayArea}
\alias{delaunayArea}
\title{Area of Delaunay triangulation}
\usage{
delaunayArea(del)
}
\arguments{
\item{del}{an output of \code{\link{delaunay}} executed with 
\code{elevation=FALSE}}
}
\value{
A number, the area of the region triangulated by the Delaunay 
  triangulation.
}
\description{
Computes the area of a region subject to Delaunay triangulation.
}
\examples{
library(RCDT)
# random points in a square ####
set.seed(666L)
library(uniformly)
square <- rbind(
  c(-1, 1), c(1, 1), c(1, -1), c(-1, -1)
)
pts <- rbind(square, runif_in_cube(8L, d = 2L))
del <- delaunay(pts)
delaunayArea(del)

# a constrained Delaunay triangulation: outer and inner squares ####
innerSquare <- rbind( # the hole
  c(-1, 1), c(1, 1), c(1, -1), c(-1, -1)
) # area: 4
outerSquare <- 2*innerSquare # area: 16
points <- rbind(innerSquare, outerSquare)
edges_inner <- rbind(c(1L, 2L), c(2L, 3L), c(3L, 4L), c(4L, 1L))
edges_outer <- edges_inner + 4L
edges <- rbind(edges_inner, edges_outer)
del <- delaunay(points, edges = edges)
delaunayArea(del) # 16-4
}
