% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bind.R
\name{Bind}
\alias{Bind}
\title{Bind}
\usage{
Bind(query_obj, ...)
}
\arguments{
\item{query_obj}{QueryClass instance-ID}

\item{...}{Binding Information}
}
\description{
Binds a value to a variable.
}
\details{
Binding information can be provided in the following ways:
    \itemize{
      \item{name, value} Name and value for a variable.
      \item{name, value, type} Name, value and type for a variable.
    }
    For a list of possibe types see \url{http://docs.basex.org/wiki/Java_Bindings#Data_Types}
}
\examples{
\dontrun{
query_txt <- "declare variable $name external; for $i in 1 to 3 return element { $name } { $i }"
query_obj <- Query(Session, query_txt)
Bind(query_obj, "$name", "number")
print(Execute(query_obj))
}

}
