% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R, R/Result.R
\docType{methods}
\name{dbGetInfo}
\alias{dbGetInfo}
\alias{dbGetInfo,AthenaConnection-method}
\alias{dbGetInfo,AthenaResult-method}
\title{Get DBMS metadata}
\usage{
\S4method{dbGetInfo}{AthenaConnection}(dbObj, ...)

\S4method{dbGetInfo}{AthenaResult}(dbObj, ...)
}
\arguments{
\item{dbObj}{An object inheriting from \linkS4class{DBIObject},
i.e. \linkS4class{DBIDriver}, \linkS4class{DBIConnection},
or a \linkS4class{DBIResult}}

\item{...}{Other arguments to methods.}
}
\value{
a named list
}
\description{
Get DBMS metadata
}
\examples{
\donttest{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(RAthena::athena())
                 
# Returns metadata from connnection object
metadata <- dbGetInfo(con)

# Return metadata from Athena query object
res <- dbSendQuery(con, "show databases")
dbGetInfo(res)

# Clear result
dbClearResult(res)

# disconnect from Athena
dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{dbGetInfo}}
}
