% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_useful_functions.R
\name{MAF.cut}
\alias{MAF.cut}
\title{Function to remove the minor alleles}
\usage{
MAF.cut(x.0, map.0 = NULL, min.MAF = 0.05, max.MS = 0.05,
  return.MAF = FALSE)
}
\arguments{
\item{x.0}{A \eqn{n \times m} original marker genotype matrix.}

\item{map.0}{Data frame with the marker names in the first column. The second and third columns contain the chromosome and map position.}

\item{min.MAF}{Specifies the minimum minor allele frequency (MAF).
If a marker has a MAF less than min.MAF, it is removed from the original marker genotype data.}

\item{max.MS}{Specifies the maximum missing rate (MS).
If a marker has a MS more than max.MS, it is removed from the original marker genotype data.}

\item{return.MAF}{If TRUE, MAF will be returned.}
}
\value{
\describe{
\item{$x}{The modified marker genotype data whose SNPs with MAF <= min.MAF were removed.}
\item{$map}{The modified map information whose SNPs with MAF <= min.MAF were removed.}
\item{$before}{Minor allele frequencies of the original marker genotype.}
\item{$after}{Minor allele frequencies of the modified marker genotype.}
}
}
\description{
Function to remove the minor alleles
}
