% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_rafs_top_reps_from_popcnts}
\alias{get_rafs_top_reps_from_popcnts}
\title{Get top (i.e., most common) representatives from their popcnts}
\usage{
get_rafs_top_reps_from_popcnts(reps_popcnts, n_clusters, n_reps = n_clusters)
}
\arguments{
\item{reps_popcnts}{popcnts for the chosen variant as obtained from \code{\link{get_rafs_reps_popcnts}}}

\item{n_clusters}{the desired number of clusters}

\item{n_reps}{the desired number of top representatives}
}
\value{
A vector of top representatives.
}
\description{
This helper function works on results of \code{\link{get_rafs_reps_popcnts}}
to obtain the desired number of top (most common) representatives at the chosen number of clusters.
}
\examples{
library(MDFS)
mdfs_omp_set_num_threads(1)  # only to pass CRAN checks
data(madelon)
rafs_results <- run_rafs(madelon$data, madelon$decision, 2, c(12345))
rafs_reps_popcnts <- get_rafs_reps_popcnts(rafs_results, 5)
get_rafs_top_reps_from_popcnts(rafs_reps_popcnts$stig_single, 5)
}
