% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CA.R
\name{corpus_ca}
\alias{corpus_ca}
\title{corpus_ca}
\usage{
corpus_ca(corpus, dtm, variables = NULL, ncp = 5, sparsity = 1, ...)
}
\arguments{
\item{corpus}{A \code{Corpus} object.}

\item{dtm}{A \code{DocumentTermMatrix} object corresponding to \code{corpus} with one row per document.}

\item{variables}{An optional list of variables in \code{\link[tm:meta]{meta(corpus)}} over which
to aggregate \code{dtm}. If \code{NULL} (the default), the analysis is run on the unaggregated matrix.}

\item{ncp}{The number of axes to compute (5 by default). Note that this determines the number
of axes that will be used for clustering by \code{\link[FactoMineR:HCPC]{HCPC}}.
Pass \code{Inf} to compute all axes.}

\item{sparsity}{Value between 0 and 1 indicating the proportion of documents
with no occurrences of a term above which that term should be dropped. By default
all terms are kept (\code{sparsity=1}).}

\item{...}{Additional arguments passed to \code{\link[FactoMineR:CA]{FactoMineR::CA}}.}
}
\value{
A \code{CA} object containing the correspondence analysis results.
}
\description{
Run a correspondence analysis on a corpus.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
corpus_ca(corpus, dtm, ncp=3, sparsity=0.98)

}
