% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordcloud.R
\name{word_cloud}
\alias{word_cloud}
\title{word_cloud}
\usage{
word_cloud(dtm, n = 50, remove_stopwords = TRUE, ...)
}
\arguments{
\item{dtm}{A \code{DocumentTermMatrix} object.}

\item{n}{The maximum number of words to plot.}

\item{remove_stopwords}{Whether to remove stopwords appearing in a language-specific list
(see \code{\link[tm:stopwords]{tm::stopwords}}).}

\item{...}{Additional arguments passed to \code{\link[wordcloud:wordcloud]{wordcloud}}.}
}
\description{
Plot a word cloud from a document-term matrix.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
word_cloud(dtm)

}
