###########################################################################/**
# @RdocDocumentation toNNN
# @alias toBMP
# @alias toEMF
# @alias toEPS
# @alias toPDF
# @alias toPNG
# @alias toSVG
# @alias toTIFF
# @alias toWMF
#
# @title "Methods for creating image files of a specific format"
#
# \description{
#  @get "title".
# }
#
# \usage{
#   toBMP(name, ..., field=getOption("devEval/args/field", "fullname"))
#   toEMF(name, ..., ext="emf", field=getOption("devEval/args/field", "fullname"))
#   toPDF(name, ..., field=getOption("devEval/args/field", "fullname"))
#   toPNG(name, ..., field=getOption("devEval/args/field", "fullname"))
#   toSVG(name, ..., field=getOption("devEval/args/field", "fullname"))
#   toTIFF(name, ..., field=getOption("devEval/args/field", "fullname"))
#   toWMF(name, ..., ext="wmf", field=getOption("devEval/args/field", "fullname"))
# }
#
# \arguments{
#   \item{name}{A @character string specifying the name of the image file.}
#   \item{...}{Additional arguments passed to @see "devEval", e.g.
#      \code{tags} and \code{aspectRatio}.}
#   \item{ext}{A @character string specifying the filename extension.}
#   \item{field}{Passed to @see "devEval".}
# }
#
# \value{
#   Returns by default the so called \emph{fullname} of the generated
#   image file.  The fullname of an file is the filename without the
#   extension.
# }
#
# @author
#
# \seealso{
#   These functions are wrappers for @see "devEval".
#   See @see "devOptions" to change the default dimensions for
#   a specific device type.
# }
#
# @keyword device
# @keyword utilities
#*/###########################################################################
toBMP <- function(name, ..., field=getOption("devEval/args/field", "fullname")) {
  devEval(type="bmp", name=name, ..., field=field);
}

toEMF <- function(name, ..., ext="emf", field=getOption("devEval/args/field", "fullname")) {
  devEval(type="win.metafile", name=name, ..., ext=ext, field=field);
}

toWMF <- function(name, ..., ext="wmf", field=getOption("devEval/args/field", "fullname")) {
  devEval(type="win.metafile", name=name, ..., ext=ext, field=field);
}

toEPS <- function(name, ..., field=getOption("devEval/args/field", "fullname")) {
  devEval(type="eps", name=name, ..., field=field);
}

toPDF <- function(name, ..., field=getOption("devEval/args/field", "fullname")) {
  devEval(type="pdf", name=name, ..., field=field);
}

toPNG <- function(name, ..., field=getOption("devEval/args/field", "fullname")) {
  devEval(type="png", name=name, ..., field=field);
}

toSVG <- function(name, ..., field=getOption("devEval/args/field", "fullname")) {
  devEval(type="svg", name=name, ..., field=field);
}

toTIFF <- function(name, ..., field=getOption("devEval/args/field", "fullname")) {
  devEval(type="tiff", name=name, ..., field=field);
}


##############################################################################
# HISTORY:
# 2013-07-24
# o Added toEMF()/toWMF().
# 2013-02-23
# o Changed default argument 'field' for toNNN() from "fullname"
#   to getOption("devEval/args/field", "fullname").
# 2012-05-01
# o Renamed Rd to toNNN.
# 2012-04-27
# o Renamed Rd to toPNG().
# 2012-04-07
# o Added toBMP() and toTIFF().
# 2011-11-05
# o Added toSVG().
# o Moved from private R.rsp.addons package to R.utils.
# o Dropped default 'width' from toPNG(), toPDF() and toEPS().  No longer
#   required from R.utils v1.9.1.
# 2011-10-31
# o CLEANUP: toPNG() etc now utilizes new 'field' argument of devEval().
# 2011-09-12
# o Added toEPS().
# 2011-06-15
# o Added argument 'field' to toPNG() and toPDF().
# 2011-05-23
# o Added toPNG() and toPDF().
##############################################################################
