% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{export_Table}
\alias{export_Table}
\title{Export a tabular object as tab-separated .txt file}
\usage{
export_Table(table, out.dir = tempdir(), out.nm = deparse(substitute(table)))
}
\arguments{
\item{table}{A tabular R object (dataframe, matrix, array)}

\item{out.dir}{The path to the output directory. Default: the working directory}

\item{out.nm}{The output filename (with or without '.txt' ending). Default: the name of \code{table} followed by '.txt'.}
}
\value{
\code{NULL}
}
\description{
Export a tabular object as tab-separated .txt file
}
\examples{
if(interactive()){
df <- data.frame('A' = seq(1:10), 'B' = rev(seq(1:10)))

export_Table(df)
}
}
