% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlashQC.R
\name{FlashQC}
\alias{FlashQC}
\title{Flash QuantumClone}
\usage{
FlashQC(Cells, conta, Nclus, model.selection = "tree")
}
\arguments{
\item{Cells}{Input for QuantumClone with genotype required}

\item{conta}{vector with contamination fraction in each sample}

\item{Nclus}{vector with the number of clusters to test (alternatively only min and max values)}

\item{model.selection}{One of "tree", "AIC", "BIC" or numeric. "tree" will use "ccc","ch" and "gap" methods from NbClust 
to determine the number of clusters. "BIC","AIC" or numeric values will use methods from QuantumClone.}
}
\description{
Fast method to find clones without filtering for multiple states
}
\examples{
set.seed(123)
#1: Cluster data
In<-QuantumClone::Input_Example
FQC<-FlashQC(In,conta = c(0,0),Nclus = 2:10)

#2: Get order variants by clones:
ord<-order(In[[1]]$Chr)
#3: Visualize clustering:
image(
 1:nrow(In[[1]]),
 1:nrow(In[[1]]),
 FQC$similarity[ord,ord], 
 xlab="", ylab="")
#4: add limit of real clusters:
abline(h = cumsum(table(In[[1]]$Chr[ord]))+1)
abline(v = cumsum(table(In[[1]]$Chr[ord]))+1)

#5: alternatively add clusters found:
ord<-order(FQC$cluster)
image(
 1:nrow(In[[1]]),
 1:nrow(In[[1]]),
 FQC$similarity[ord,ord], 
 xlab="", ylab="")
abline(h = cumsum(table(FQC$cluster[ord]))+1)
abline(v = cumsum(table(FQC$cluster[ord]))+1)
# Show clustering quality:
NMI_cutree( FQC$cluster,chr = In[[1]]$Chr)
}
\seealso{
QuantumClone
}

