% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/QuantumCat.R
\name{statistics_on_Multitest}
\alias{statistics_on_Multitest}
\title{Multiple testing}
\usage{
statistics_on_Multitest(number_of_tests_per_condition = 100,
  range_clones = 2:5, range_mutations = c(50, 80, 100, 250, 500),
  range_ploidy = c(2, 3), range_samples = c(2, 3, 4, 5, 7, 10),
  range_depth = c(50, 80, 100, 250, 500, 50000), range_contamination = c(0,
  0.25, 0.5, 0.75), folder = "stat", plot_results = T, save_Cell = F,
  preclustering = T, nclone_range = 2:5, maxit = 4, epsilon = 5 *
  (10^(-3)), ncores = 4)
}
\arguments{
\item{number_of_tests_per_condition}{The number of times the QuantumCat function should be called}

\item{range_clones}{The range of observable clones (meaning bearing at least 1 mutation)}

\item{range_mutations}{The total number of observed number of mutations (across all clones)}

\item{range_ploidy}{The general ploidy of the tumor. Default is 2.}

\item{range_samples}{The number of samples on which the data should be simulated. Default is 2.}

\item{range_depth}{The depth of sequencing (does not account for contamination). Default is 100x}

\item{range_contamination}{A numeric vector indicating the fraction of normal cells in samples.}

\item{folder}{Name of the folder in which the statistics will be saved}

\item{plot_results}{Should the intermediate results be plotted and saved? Default is TRUE}

\item{save_Cell}{Should the dataframe with the cellularities be saved? Default is FALSE}

\item{preclustering}{Should the data be pre-clustered by k-means?}

\item{nclone_range}{Range of values tested for the maximum likelihood}

\item{maxit}{Number of trials different initial conditions to be used to evaluate the mximum likelihood}

\item{epsilon}{The stop value of the EM algorithm}

\item{ncores}{Number of cores to be used for the optimization research}
}
\description{
Call the Multitest function on different parameters to evaluate the influence of each according to the model. Does not save plot results.
}
\examples{
\dontrun{
statistics_on_Multitest(number_of_tests_per_condition=2,range_clones=2:3,range_mutations=c(20),
                                 range_ploidy="AB",range_samples=2,range_depth=1000,
                                 range_contamination = 0,folder='stat',
                                 plot_results=FALSE,save_Cell=FALSE,preclustering = TRUE ,
                                 nclone_range = 2 ,maxit = 1, epsilon = 5*(10**(-3)),ncores = 1)
}
}
\keyword{Data}
\keyword{generation}
\keyword{phylogeny}

