% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Quandl.R
\name{Quandl.dataset.get}
\alias{Quandl.dataset.get}
\title{Pulls Data from the Quandl Dataset endpoint}
\usage{
Quandl.dataset.get(code, params)
}
\arguments{
\item{code}{Dataset code on Quandl specified as a string or an array of strings.}

\item{params}{A list of parameters to be passed to the Quandl api.}
}
\value{
Returns a data.frame of the requested data
}
\description{
An authentication token is needed for access to the Quandl API multiple times. Set your \code{access_token} with \code{Quandl.auth} function.
}
\details{
For instructions on finding your authentication token go to https://www.quandl.com/account
}
\examples{
\dontrun{
quandldata = Quandl.dataset.get("NSE/OIL", list(rows=5))
plot(quandldata[,1])
}
}
\author{
Raymond McTaggart
}
\references{
This R package uses the Quandl API. For more information go to https://www.quandl.com/help/api. For more help on the package itself go to http://www.quandl.com/help/r.
}
\seealso{
\code{\link{Quandl.auth}}
}

