% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/QPGlobal.R
\name{QPGlobal}
\alias{QPGlobal}
\title{Finding the global quasi-potential}
\usage{
QPGlobal(local.surfaces, unstable.eq.x, unstable.eq.y, x.bound, y.bound)
}
\arguments{
\item{local.surfaces}{A list of local quasi-potential surfaces, each of which is stored in discretized form as a matrix.}

\item{unstable.eq.x}{A vector of the x-coordinates of the unstable equilibria.  Must be in the same order as unstable.eq.y.}

\item{unstable.eq.y}{A vector of the y-coordinates of the unstable equilibria.  Must be in the same order as unstable.eq.x.}

\item{x.bound}{A two-element vector with the minimum and maximum x values used for computing the quasi-potential.}

\item{y.bound}{A two-element vector with the minimum and maximum y values used for computing the quasi-potential.}
}
\description{
This function allows you to find the global quasi-potential values for several local quasi-potential surfaces
}
\examples{
# First, System of equations
	equationx <- "1.54*x*(1.0-(x/10.14)) - (y*x*x)/(1.0+x*x)"
	equationy <- "((0.476*x*x*y)/(1+x*x)) - 0.112590*y*y"

# Second, shared parameters for each quasi-potential run
	xbounds <- c(-0.5, 10.0)
	ybounds <- c(-0.5, 10.0)
	xstepnumber <- 100
	ystepnumber <- 100

# Third, first local quasi-potential run
	xinit1 <- 1.40491
	yinit1 <- 2.80808
	storage.eq1 <- QPotential(x.rhs = equationx, x.start = xinit1,
		x.bound = xbounds, x.num.steps = xstepnumber, y.rhs = equationy,
		y.start = yinit1, y.bound = ybounds, y.num.steps = ystepnumber)

# Fourth, second local quasi-potential run
	xinit2 <- 4.9040
	yinit2 <- 4.06187
	storage.eq2 <- QPotential(x.rhs = equationx, x.start = xinit2,
		x.bound = xbounds, x.num.steps = xstepnumber, y.rhs = equationy,
		y.start = yinit2, y.bound = ybounds, y.num.steps = ystepnumber)

# Fifth, determine global quasi-potential
	unst.x <- c(0, 4.2008)
	unst.y <- c(0, 4.0039)
	ex1.global <- QPGlobal(local.surfaces = list(storage.eq1, storage.eq2),
		unstable.eq.x = unst.x, unstable.eq.y = unst.y, x.bound = xbounds,
		y.bound = ybounds)
}
\keyword{Global}
\keyword{quasi-potential}

