\name{plot1}

\alias{plot1}

\title{Display the distribution of points for a single condition}

\description{
This function creates a plot for a single vector of numerical values, arranging them
horizontally from minimum to maximum.
}

\usage{
plot1(x, jitter = FALSE, at = NULL, ...)
}

\arguments{
  \item{x}{A numeric vector.}
  \item{jitter}{Logical, vertically jitter the points.}
  \item{at}{The points at which tick-marks are to be drawn. Non-finite (infinite, NaN or NA)
            values are omitted. By default (when NULL) tickmark locations are automatically
            computed, see the help file for \bold{\code{?axis}}.}
  \item{...}{Other graphical parameters from \code{par}}
}

\details{
This is a special type of (scatter)plot, with points being arranged only on the
horizontal axis (it has no vertical axis). Useful when inspecting if points
are grouped into naturally occuring clusters, mainly for crisp calibration purposes.

The argument \bold{\code{...}} is used to pass various graphical parameters for the
various plotting functions used.

The points have a default \bold{\code{cex}} (character expansion) value of 1, and
a default \bold{\code{pch}} value of 1 (empty points), which can be modified
accordingly (for example with value 21 for filled points). When \bold{\code{pch = 21}},
the color for the margins of the points can be specified via the argument
\bold{\code{col}}, while the argument \bold{\code{bg}} will determine the fill color
of the points.

The axis labels have a default \bold{\code{cex.axis}} value of 0.8, which affects
both the tickmarks labels and the axis labels.

When jittering the points, default values of 0.5 are used for the parameters
\bold{\code{factor}} and \bold{\code{amount}}, on the horizontal axis.
}

\author{
Adrian Dusa
}

\seealso{\code{\link{par}}, \code{\link{text}}, \code{\link{jitter}}}

\examples{

# Lipset's raw data
data(LR)

# plot the DEV (level of developent) causal condition
plot1(LR$DEV)

# jitter the points vertically
plot1(LR$DEV, jitter = TRUE)

# make the x axis large enough to accommodate all values
plot1(LR$DEV, jitter = TRUE, at = pretty(LR$DEV))

# clip plotting between the range of min and max
plot1(LR$DEV, jitter = TRUE, at = range(LR$DEV))
}


\keyword{functions}
