% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWV2_dynamic.R
\name{text_unmask}
\alias{text_unmask}
\title{Fill in the blank mask(s) in a query (sentence).}
\usage{
text_unmask(query, model, topn = 5)
}
\arguments{
\item{query}{A query (sentence/prompt) with masked token(s) \code{[MASK]}.
See examples.}

\item{model}{Model name at \href{https://huggingface.co/models}{HuggingFace}.
See \code{\link{text_model_download}}.
If the model has not been downloaded, it would automatically download the model.}

\item{topn}{Number of predictions to return. Defaults to \code{5}.}
}
\value{
A \code{data.table} of query results:
\describe{
  \item{\code{mask_id}}{
    \code{[MASK]} ID (position in sequence, indicating multiple masks)}
  \item{\code{prob}}{
    Probability of the predicted token in the sequence}
  \item{\code{token_id}}{
    Predicted token ID (to replace \code{[MASK]})}
  \item{\code{token}}{
    Predicted token (to replace \code{[MASK]})}
  \item{\code{sequence}}{
    Complete sentence with the predicted token}
}
}
\description{
Predict the probably correct masked token(s) in a sequence,
based on the Python module \code{transformers}.
}
\details{
Masked language modeling is the task of masking some of the words in a sentence
and predicting which words should replace those masks.
These models are useful when we want to get a statistical understanding of
the language in which the model is trained in.
See \url{https://huggingface.co/tasks/fill-mask} for details.
}
\examples{
\dontrun{
# text_init()  # initialize the environment

model = "distilbert-base-cased"
text_unmask("Beijing is the [MASK] of China.", model)
text_unmask("Beijing is the [MASK] [MASK] of China.", model)
text_unmask("The man worked as a [MASK].", model)
text_unmask("The woman worked as a [MASK].", model)
}

}
\seealso{
\code{\link{text_init}}

\code{\link{text_model_download}}

\code{\link{text_model_remove}}

\code{\link{text_to_vec}}
}
