% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procmod_frame.R
\name{as_procmod_frame}
\alias{as_procmod_frame}
\alias{as_procmod_frame.list}
\alias{as_procmod_frame.procmod_frame}
\alias{as_procmod_frame.array}
\alias{as_procmod_frame.matrix}
\title{Coerce to a ProcMod Frame.}
\usage{
as_procmod_frame(data, ...)

\method{as_procmod_frame}{list}(data, ...)

\method{as_procmod_frame}{procmod_frame}(data, ...)

\method{as_procmod_frame}{array}(data, ...)

\method{as_procmod_frame}{matrix}(data, ...)
}
\arguments{
\item{data}{a R object to coerce.}

\item{...}{supplementary parameters used in some
implementation of that method}
}
\value{
a \code{procmod_frame} object
}
\description{
Conversion methods are proposed for \code{list},
\code{matrix} and \code{array}.
}
\examples{
# Builds a list containing two random matrices
m1 <- simulate_matrix(10,20)
m2 <- simulate_matrix(10,30)
l <- list(m1 = m1, m2 = m2)

# Converts the list to a procmod_frame
pmf1 <- as_procmod_frame(l)

# Builds a procmod_frame from a matrix
m3 <- matrix(1:12,nrow=3)
pmf2 <- as_procmod_frame(matrix(1:12,nrow=3))
# Returns 4, the column count of the input matrix
length(pmf2)

# Builds a 3D array
a <- array(1:24,dim = c(3,4,2))

# The conversion to a procmod_frame makes
# an procmod element from each third dimension
as_procmod_frame(a)

}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
