% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{rawToUnsignedInt}
\alias{rawToUnsignedInt}
\title{Convert raw vector into a single unsigned integer value}
\usage{
rawToUnsignedInt(raw_dat)
}
\arguments{
\item{raw_dat}{A vector of class \code{raw} to be converted into an unsigned integer}
}
\value{
A single unsigned integer value based on the provided \code{raw} data
}
\description{
This function converts \code{raw} data into an unsigned integer
}
\details{
This function converts a vector of raw data into a single unsigned integer.
for conversion of raw data into a vector of unsigned integers [0,255] use
`\code{\link{as.integer}(x)}'. For an inverse of this function
see \code{\link{unsignedIntToRaw}}.
}
\examples{
## generate some raw data:
some.raw.data <- as.raw(c(0x01, 0x1e, 0x3f))

## convert raw data into an unsigned integer:
rawToUnsignedInt(some.raw.data)

## note the difference with
as.integer(some.raw.data)
}
\author{
Pepijn de Vries
}
\seealso{
Other integer.operations: \code{\link{hiNybble}},
  \code{\link{loNybble}}, \code{\link{nybble}};
  \code{\link{nybbleToSignedInt}};
  \code{\link{rawToSignedInt}};
  \code{\link{signedIntToNybble}};
  \code{\link{signedIntToRaw}};
  \code{\link{unsignedIntToRaw}}; \code{\link{waveform}},
  \code{\link{waveform,PTSample-method}},
  \code{\link{waveform<-}},
  \code{\link{waveform<-,PTSample-method}}

Other raw.operations: \code{\link{as.raw}},
  \code{\link{as.raw,PTCell-method}},
  \code{\link{as.raw,PTPattern-method}},
  \code{\link{as.raw,PTTrack-method}},
  \code{\link{as.raw<-}},
  \code{\link{as.raw<-,PTCell,raw-method}},
  \code{\link{as.raw<-,PTPattern,matrix-method}},
  \code{\link{as.raw<-,PTTrack,matrix-method}};
  \code{\link{hiNybble}}, \code{\link{loNybble}},
  \code{\link{nybble}}; \code{\link{nybbleToSignedInt}};
  \code{\link{rawToCharNull}};
  \code{\link{rawToSignedInt}};
  \code{\link{signedIntToNybble}};
  \code{\link{signedIntToRaw}};
  \code{\link{unsignedIntToRaw}}
}

