% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/05PTSample.r
\docType{methods}
\name{loopSample}
\alias{loopSample}
\alias{loopSample,PTSample-method}
\title{Looped waveform of a sample}
\usage{
\S4method{loopSample}{PTSample}(sample, times, n_samples)
}
\arguments{
\item{sample}{A \code{\link{PTSample}} object that needs to be looped.}

\item{times}{A positive \code{integer} value indicating the number of
times a sample loop should be repeated. This argument is ignore if
\code{n_samples} is specified.}

\item{n_samples}{A positive \code{integer} value indicating the desired length
of the looped waveform in number of samples. This argument overrules the
\code{times} argument.}
}
\value{
Returns a \code{\link{waveform}} represented by a \code{numeric}
\code{vector} of values ranging from 0 up to 255. Has a length of
\code{n_samples} when that argument is specified.
}
\description{
Generate a looped \code{\link{waveform}} of a \code{\link{PTSample}} object.
}
\details{
For playing routines, it can be useful to generate repeats of a sample loop.
This method returns the waveform of a \code{\link{PTSample}} where the
loop is repeated `\code{times}' times or has a length of `\code{n_samples}'.
}
\examples{
data("mod.intro")

## Loop sample number 4 10 times:
wform <- loopSample(PTSample(mod.intro, 4), times = 10)
plot(wform, type = "l")

## Loop sample number 4, such that its
## final length is 5000 samples:
wform <- loopSample(PTSample(mod.intro, 4), n_samples = 5000)
plot(wform, type = "l")
}
\author{
Pepijn de Vries
}
\seealso{
Other loop.methods: \code{\link{loopLength}},
  \code{\link{loopLength,PTSample-method}},
  \code{\link{loopLength<-}},
  \code{\link{loopLength<-,PTSample-method}};
  \code{\link{loopStart}},
  \code{\link{loopStart,PTSample-method}},
  \code{\link{loopStart<-}},
  \code{\link{loopStart<-,PTSample-method}};
  \code{\link{loopState}},
  \code{\link{loopState,PTSample-method}}

Other sample.operations: \code{\link{PTSample,PTModule,numeric-method}},
  \code{\link{PTSample,Wave,missing-method}},
  \code{\link{PTSample,raw,missing-method}},
  \code{\link{PTSample-method}}, \code{\link{PTSample<-}},
  \code{\link{PTSample<-,PTModule,numeric,PTSample-method}};
  \code{\link{PTSample}}, \code{\link{PTSample-class}};
  \code{\link{fineTune}},
  \code{\link{fineTune,PTSample-method}},
  \code{\link{fineTune<-}},
  \code{\link{fineTune<-,PTSample,numeric-method}};
  \code{\link{loopLength}},
  \code{\link{loopLength,PTSample-method}},
  \code{\link{loopLength<-}},
  \code{\link{loopLength<-,PTSample-method}};
  \code{\link{loopStart}},
  \code{\link{loopStart,PTSample-method}},
  \code{\link{loopStart<-}},
  \code{\link{loopStart<-,PTSample-method}};
  \code{\link{loopState}},
  \code{\link{loopState,PTSample-method}};
  \code{\link{name}}, \code{\link{name,PTModule-method}},
  \code{\link{name,PTSample-method}}, \code{\link{name<-}},
  \code{\link{name<-,PTModule,character-method}},
  \code{\link{name<-,PTSample,character-method}};
  \code{\link{playSample}},
  \code{\link{playSample,PTModule-method}},
  \code{\link{playSample,PTSample-method}};
  \code{\link{read.sample}},
  \code{\link{read.sample,character-method}};
  \code{\link{sampleLength}},
  \code{\link{sampleLength,PTSample-method}};
  \code{\link{volume}},
  \code{\link{volume,PTSample-method}},
  \code{\link{volume<-}},
  \code{\link{volume<-,PTSample,numeric-method}};
  \code{\link{waveform}},
  \code{\link{waveform,PTSample-method}},
  \code{\link{waveform<-}},
  \code{\link{waveform<-,PTSample-method}};
  \code{\link{write.sample}},
  \code{\link{write.sample,PTSample,character-method}}
}

